/*
 * Decompiled with CFR 0.152.
 */
package selfservice.filter;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;
import selfservice.domain.CoinAuthentication;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.Group;
import selfservice.service.VootClient;
import selfservice.util.SpringSecurity;

public class VootFilter
extends GenericFilterBean {
    private static final Logger logger = LoggerFactory.getLogger(VootFilter.class);
    public static final String SESSION_KEY_GROUP_ACCESS = "SESSION_KEY_GROUP_ACCESS";
    protected static final String PROCESSED = "selfservice.filter.VootFilter.PROCESSED";
    private VootClient vootClient;
    private final String dashboardAdmin;
    private final String dashboardViewer;
    private final String dashboardSuperUser;

    public VootFilter(VootClient vootClient, String dashboardAdmin, String dashboardViewer, String dashboardSuperUser) {
        this.vootClient = vootClient;
        this.dashboardAdmin = dashboardAdmin;
        this.dashboardViewer = dashboardViewer;
        this.dashboardSuperUser = dashboardSuperUser;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(true);
        this.addVootRoles(session);
        chain.doFilter(request, response);
    }

    private void addVootRoles(HttpSession session) {
        if (!SpringSecurity.isFullyAuthenticated() || session.getAttribute(PROCESSED) != null) {
            return;
        }
        CoinUser user = SpringSecurity.getCurrentUser();
        List groups = this.vootClient.groups(user.getUid());
        this.addDashboardRole(user, groups);
        if (logger.isDebugEnabled()) {
            logger.debug("Roles based on VOOT {}", (Object)user.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(", ")));
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)new CoinAuthentication(user));
        session.setAttribute(PROCESSED, (Object)"true");
    }

    private void addDashboardRole(CoinUser user, List<Group> groups) {
        if (this.groupsContains(this.dashboardSuperUser, groups)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER));
        } else if (this.groupsContains(this.dashboardAdmin, groups)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
        } else if (this.groupsContains(this.dashboardViewer, groups)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
        }
    }

    private boolean groupsContains(String teamId, List<Group> groups) {
        return groups.stream().anyMatch(group -> teamId.equalsIgnoreCase(group.getId()));
    }
}

