/*
 * Decompiled with CFR 0.152.
 */
package selfservice.manage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import selfservice.domain.IdentityProvider;
import selfservice.domain.Provider;
import selfservice.domain.ServiceProvider;
import selfservice.manage.EntityType;

public interface Manage {
    public static final String guestIdp = "https://www.onegini.me";
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public List<ServiceProvider> getAllServiceProviders();

    public Optional<ServiceProvider> getServiceProvider(String var1, EntityType var2);

    public Optional<ServiceProvider> getServiceProviderById(Long var1, EntityType var2);

    public Optional<IdentityProvider> getIdentityProvider(String var1);

    public List<IdentityProvider> getInstituteIdentityProviders(String var1);

    public List<ServiceProvider> getInstitutionalServicesForIdp(String var1);

    public List<IdentityProvider> getAllIdentityProviders();

    public List<IdentityProvider> getLinkedIdentityProviders(String var1);

    default public ServiceProvider serviceProvider(Map<String, Object> map, EntityType entityType) {
        ServiceProvider serviceProvider = new ServiceProvider(map);
        serviceProvider.setExampleSingleTenant(entityType.equals((Object)EntityType.single_tenant_template));
        return serviceProvider;
    }

    default public IdentityProvider identityProvider(Map<String, Object> map) {
        return new IdentityProvider(map);
    }

    default public <T extends Provider> Map<String, T> parseProviders(Resource resource, Function<Map<String, Object>, T> provider) throws IOException {
        List providers = (List)objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Map result = providers.stream().filter(stringObjectMap -> ((Map)Map.class.cast(stringObjectMap.get("data"))).get("state").equals("prodaccepted")).map(arg_0 -> this.transformManageMetadata(arg_0)).map(provider).collect(Collectors.toSet()).stream().collect(Collectors.toMap(Provider::getId, Function.identity()));
        return result;
    }

    default public boolean isConnectionAllowed(ServiceProvider sp, IdentityProvider idp) {
        return !(!sp.isAllowedAll() && !sp.getAllowedEntityIds().contains(idp.getId()) || !idp.isAllowedAll() && !idp.getAllowedEntityIds().contains(sp.getId()));
    }

    default public Map<String, Object> transformManageMetadata(Map<String, Object> metadata) {
        Map data = (Map)metadata.get("data");
        HashMap<String, Object> result = new HashMap<String, Object>();
        data.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                result.put(key, (Boolean)Boolean.class.cast(value) != false ? "yes" : "no");
            } else if (value instanceof String) {
                result.put(key, value);
            } else if (value instanceof Number) {
                result.put(key, value);
            }
            switch (key) {
                case "metaDataFields": {
                    Map metaDataFields = (Map)value;
                    result.putAll(metaDataFields);
                    break;
                }
                case "arp": {
                    Map arp = (Map)value;
                    Boolean enabled = (Boolean)arp.get("enabled");
                    if (!enabled.booleanValue()) break;
                    Map attributes = (Map)arp.get("attributes");
                    Map<String, List> attributesList = attributes.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Collections.singletonList(((Map)((List)e.getValue()).get(0)).get("value"))));
                    result.put("attributes", attributesList);
                    break;
                }
                case "allowedEntities": {
                    List allowedEntities = (List)value;
                    List allowedEntitiesList = allowedEntities.stream().map(m -> (String)m.get("name")).collect(Collectors.toList());
                    result.put("allowedEntities", allowedEntitiesList);
                    break;
                }
            }
        });
        return result;
    }
}

