/*
 * Decompiled with CFR 0.152.
 */
package selfservice.sab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import selfservice.sab.Sab;
import selfservice.sab.SabPerson;
import selfservice.sab.SabRole;
import selfservice.sab.SabRoleHolder;

public class SabClientMock
implements Sab {
    private static final SabRole ROLE_BEHEERDER = new SabRole("CONBEH", "SURFconextbeheerder");
    private static final SabRole ROLE_VERANTWOORDELIJKE = new SabRole("CONVER", "SURFconextverantwoordelijke");
    private final List<SabPerson> sabPersons = ImmutableList.of((Object)new SabPerson("Hans", "Janssen", "hjanssen", Arrays.asList(ROLE_BEHEERDER)), (Object)new SabPerson("Frans", "Franssen", "ffransen", Arrays.asList(ROLE_BEHEERDER, ROLE_VERANTWOORDELIJKE)));
    private final Map<String, SabRoleHolder> rolesMapping = ImmutableMap.of((Object)"user1", (Object)new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Bar")), (Object)"user2", (Object)new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Baz")), (Object)"noroles", (Object)new SabRoleHolder("SURFNET", Collections.emptyList()));

    public Optional<SabRoleHolder> getRoles(String userId) {
        return Optional.ofNullable(this.rolesMapping.get(userId));
    }

    public Collection<SabPerson> getPersonsInRoleForOrganization(String organisationAbbreviation, String role) {
        return this.sabPersons.stream().filter(person -> person.getRoles().stream().anyMatch(r -> r.roleName.equals(role))).collect(Collectors.toList());
    }
}

