/*
 * Decompiled with CFR 0.152.
 */
package selfservice.service.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import selfservice.domain.Category;
import selfservice.domain.CategoryValue;
import selfservice.domain.ContactPerson;
import selfservice.domain.ContactPersonType;
import selfservice.domain.IdentityProvider;
import selfservice.domain.Provider;
import selfservice.domain.Service;
import selfservice.domain.ServiceProvider;
import selfservice.manage.EntityType;
import selfservice.manage.Manage;
import selfservice.service.Services;

public class ServicesImpl
implements Services {
    @Autowired
    private Manage manage;

    public List<Service> getServicesForIdp(String idpEntityId, Locale locale) {
        IdentityProvider identityProvider = (IdentityProvider)this.manage.getIdentityProvider(idpEntityId).orElseThrow(() -> new IllegalArgumentException(String.format("IDP %s does not exists", idpEntityId)));
        List allServiceProviders = this.manage.getAllServiceProviders();
        List<Service> services = allServiceProviders.stream().map(sp -> {
            Service service = this.buildApiService(sp, locale.getLanguage());
            boolean connectedToIdentityProvider = identityProvider.isAllowedAll() || identityProvider.getAllowedEntityIds().contains(sp.getId());
            boolean allowedBySp = sp.isAllowedAll() || sp.getAllowedEntityIds().contains(idpEntityId);
            service.setConnected(connectedToIdentityProvider && allowedBySp);
            return service;
        }).filter(service -> !service.isIdpVisibleOnly() || service.isConnected() || service.getInstitutionId() != null && service.getInstitutionId().equals(identityProvider.getInstitutionId())).collect(Collectors.toList());
        return services;
    }

    public Optional<Service> getServiceByEntityId(String idpEntityId, String spEntityId, EntityType entityType, Locale locale) {
        Optional serviceProvider = this.manage.getServiceProvider(spEntityId, entityType);
        return this.enrichService(idpEntityId, locale, serviceProvider);
    }

    public Optional<Service> getServiceById(String idpEntityId, Long spId, EntityType entityType, Locale locale) throws IOException {
        Optional serviceProvider = this.manage.getServiceProviderById(spId, entityType);
        return this.enrichService(idpEntityId, locale, serviceProvider);
    }

    private Optional<Service> enrichService(String idpEntityId, Locale locale, Optional<ServiceProvider> serviceProvider) {
        IdentityProvider identityProvider = (IdentityProvider)this.manage.getIdentityProvider(idpEntityId).orElseThrow(() -> new IllegalArgumentException(String.format("IDP %s does not exists", idpEntityId)));
        return serviceProvider.map(sp -> {
            boolean connectedToIdentityProvider = identityProvider.isAllowedAll() || identityProvider.getAllowedEntityIds().contains(sp.getId());
            boolean allowedBySp = sp.isAllowedAll() || sp.getAllowedEntityIds().contains(idpEntityId);
            Service service = this.buildApiService(sp, locale.getLanguage());
            service.setConnected(connectedToIdentityProvider && allowedBySp);
            return service;
        });
    }

    public List<Service> getInstitutionalServicesForIdp(String institutionId, Locale locale) {
        List institutionalServicesForIdp = this.manage.getInstitutionalServicesForIdp(institutionId);
        return this.buildApiServices(institutionalServicesForIdp, locale.getLanguage());
    }

    private List<Service> buildApiServices(List<ServiceProvider> services, String language) {
        return services.stream().map(service -> this.buildApiService(service, language)).collect(Collectors.toList());
    }

    private Service buildApiService(ServiceProvider serviceProvider, String language) {
        boolean isEn = language.equalsIgnoreCase("en");
        Service service = new Service();
        this.plainProperties(serviceProvider, service);
        this.languageSpecificProperties(serviceProvider, isEn, service);
        this.categories(serviceProvider, service, language);
        this.contactPersons(serviceProvider, service);
        return service;
    }

    private void plainProperties(ServiceProvider sp, Service service) {
        service.setSpEntityId(sp.getId());
        service.setAppUrl(sp.getApplicationUrl());
        service.setId(sp.getEid().longValue());
        service.setEulaUrl(sp.getEulaURL());
        service.setDetailLogoUrl(sp.getLogoUrl());
        service.setLogoUrl(sp.getLogoUrl());
        service.setSupportMail(this.mailOfContactPerson(sp.getContactPerson(ContactPersonType.help)));
        Map homeUrls = sp.getHomeUrls();
        service.setWebsiteUrl(CollectionUtils.isEmpty((Map)homeUrls) ? null : (String)homeUrls.values().iterator().next());
        service.setArp(sp.getArp());
        service.setIdpVisibleOnly(sp.isIdpVisibleOnly());
        service.setPolicyEnforcementDecisionRequired(sp.isPolicyEnforcementDecisionRequired());
        service.setInstitutionId(sp.getInstitutionId());
        service.setPublishedInEdugain(sp.isPublishedInEdugain());
        service.setLicenseStatus(sp.getLicenseStatus());
        service.setExampleSingleTenant(sp.isExampleSingleTenant());
        service.setInterfedSource(sp.getInterfedSource());
        service.setRegistrationInfoUrl(sp.getRegistrationInfo());
        service.setEntityCategories1(sp.getEntityCategories1());
        service.setEntityCategories2(sp.getEntityCategories2());
        service.setPublishInEdugainDate(sp.getPublishInEdugainDate());
        service.setStrongAuthentication(sp.isStrongAuthenticationSupported());
        service.setNames(sp.getNames());
        service.setDescriptions(sp.getDescriptions());
        service.setNoConsentRequired(sp.isNoConsentRequired());
        service.setPrivacyInfo(sp.getPrivacyInfo());
        service.setMotivations(sp.getArpMotivations());
        service.setNormenkaderPresent(sp.getPrivacyInfo().isGdprIsInWiki());
        service.setAansluitovereenkomstRefused(sp.isAansluitovereenkomstRefused());
        service.setGuestEnabled(sp.isAllowedAll() || sp.getAllowedEntityIds() != null && sp.getAllowedEntityIds().contains("https://www.onegini.me"));
    }

    private String mailOfContactPerson(ContactPerson contactPerson) {
        return contactPerson == null ? null : contactPerson.getEmailAddress();
    }

    private void languageSpecificProperties(ServiceProvider sp, boolean en, Service service) {
        if (en) {
            service.setDescription(sp.getDescription(Provider.Language.EN));
            service.setEnduserDescription(sp.getDescription(Provider.Language.EN));
            service.setName(sp.getName(Provider.Language.EN));
            service.setSupportUrl(sp.getUrl(Provider.Language.EN));
            service.setInstitutionDescription(sp.getDescription(Provider.Language.EN));
            service.setServiceUrl(sp.getUrl(Provider.Language.EN));
            service.setWikiUrl(sp.getWikiUrlEn());
            service.setSpName(sp.getName(Provider.Language.EN));
            service.setRegistrationPolicyUrl(sp.getRegistrationPolicyUrlEn());
            service.setPrivacyStatementUrl(sp.getPrivacyStatementUrlEn());
        } else {
            service.setDescription(sp.getDescription(Provider.Language.NL));
            service.setEnduserDescription(sp.getDescription(Provider.Language.NL));
            service.setName(sp.getName(Provider.Language.NL));
            service.setSupportUrl(sp.getUrl(Provider.Language.NL));
            service.setInstitutionDescription(sp.getDescription(Provider.Language.NL));
            service.setServiceUrl(sp.getUrl(Provider.Language.NL));
            service.setWikiUrl(sp.getWikiUrlNl());
            service.setSpName(sp.getName(Provider.Language.NL));
            service.setRegistrationPolicyUrl(sp.getRegistrationPolicyUrlNl());
            service.setPrivacyStatementUrl(sp.getPrivacyStatementUrlNl());
        }
    }

    private void categories(ServiceProvider sp, Service service, String locale) {
        List typeOfServices = locale.equals("en") ? sp.getTypeOfServicesEn() : sp.getTypeOfServicesNl();
        Category category = new Category(locale.equals("en") ? "Type of Service" : "Type Service", typeOfServices.stream().map(CategoryValue::new).collect(Collectors.toList()));
        service.setCategories(Collections.singletonList(category));
    }

    private void contactPersons(ServiceProvider sp, Service service) {
        List contactPersons = sp.getContactPersons();
        if (!CollectionUtils.isEmpty((Collection)contactPersons)) {
            service.setContactPersons(contactPersons.stream().filter(contactPerson -> contactPerson.isSirtfiSecurityContact()).collect(Collectors.toList()));
        }
    }

    private boolean showServiceForInstitution(IdentityProvider identityProvider, Service service) {
        return !service.isIdpVisibleOnly() || service.getInstitutionId() != null && service.getInstitutionId().equalsIgnoreCase(identityProvider.getInstitutionId());
    }
}

