/*
 * Decompiled with CFR 0.152.
 */
package selfservice.shibboleth;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.IdentityProvider;
import selfservice.manage.Manage;
import selfservice.shibboleth.ShibbolethHeader;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final Map<String, ShibbolethHeader> shibHeaders;
    private static final Splitter shibHeaderValueSplitter;
    private static final Logger LOG;
    private Manage manage;
    private String dashboardAdmin;
    private String dashboardViewer;
    private String dashboardSuperUser;
    private String adminSurfConextIdpRole;
    private String viewerSurfConextIdpRole;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, Manage manage, String dashboardAdmin, String dashboardViewer, String dashboardSuperUser, String adminSufConextIdpRole, String viewerSurfConextIdpRole) {
        this.setAuthenticationManager(authenticationManager);
        this.manage = manage;
        this.dashboardAdmin = dashboardAdmin;
        this.dashboardSuperUser = dashboardSuperUser;
        this.dashboardViewer = dashboardViewer;
        this.adminSurfConextIdpRole = adminSufConextIdpRole;
        this.viewerSurfConextIdpRole = viewerSurfConextIdpRole;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        Enumeration headerNames;
        String uid = (String)this.getFirstShibHeaderValue(ShibbolethHeader.Name_Id, request).orElseThrow(() -> new IllegalArgumentException(String.format("Missing name-id Shibboleth header (%s)", request.getRequestURL())));
        String idpId = (String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_Authenticating_Authority, request).orElseThrow(() -> new IllegalArgumentException("Missing Shib-Authenticating-Authority Shibboleth header"));
        if (LOG.isDebugEnabled() && (headerNames = request.getHeaderNames()) != null) {
            ArrayList list = Collections.list(headerNames);
            LOG.debug("Received headers for {}: {} ", (Object)uid, list.stream().collect(Collectors.toMap(name -> name, name -> {
                Enumeration headers = request.getHeaders(name);
                return headers != null ? Collections.list(headers) : Collections.emptyList();
            })));
        }
        CoinUser coinUser = new CoinUser();
        coinUser.setUid(uid);
        coinUser.setDisplayName((String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_DisplayName, request).orElse(null));
        coinUser.setEmail((String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_Email, request).orElse(null));
        coinUser.setSchacHomeOrganization((String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_HomeOrg, request).orElse(null));
        Map<ShibbolethHeader, List> attributes = shibHeaders.values().stream().filter(h -> StringUtils.hasText((String)request.getHeader(h.getValue()))).collect(Collectors.toMap(h -> h, h -> this.getShibHeaderValues(h, request)));
        coinUser.setAttributeMap(attributes);
        List groups = this.getShibHeaderValues(ShibbolethHeader.Shib_MemberOf, request);
        this.addDashboardRoleForMemberships(coinUser, groups);
        List entitlements = this.getShibHeaderValues(ShibbolethHeader.Shib_EduPersonEntitlement, request);
        this.addDashboardRoleForEntitlements(coinUser, entitlements);
        List institutionIdentityProviders = this.getInstitutionIdentityProviders(idpId);
        Preconditions.checkState((!CollectionUtils.isEmpty((Collection)institutionIdentityProviders) ? 1 : 0) != 0, (Object)("no InstitutionIdentityProviders found for '" + idpId + "'"));
        if (institutionIdentityProviders.size() == 1) {
            IdentityProvider idp2 = (IdentityProvider)institutionIdentityProviders.get(0);
            coinUser.setIdp(idp2);
            coinUser.addInstitutionIdp(idp2);
        } else {
            coinUser.setIdp(this.getCurrentIdp(idpId, institutionIdentityProviders));
            coinUser.getInstitutionIdps().addAll(institutionIdentityProviders);
            Collections.sort(coinUser.getInstitutionIdps(), (lh, rh) -> lh.getName().compareTo(rh.getName()));
        }
        institutionIdentityProviders.stream().filter(idp -> StringUtils.hasText((String)idp.getInstitutionId())).findFirst().ifPresent(idp -> coinUser.setInstitutionId(idp.getInstitutionId()));
        return coinUser;
    }

    private void addDashboardRoleForMemberships(CoinUser user, List<String> groups) {
        if (groups.contains(this.dashboardSuperUser)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER));
        } else if (groups.contains(this.dashboardAdmin)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
        } else if (groups.contains(this.dashboardViewer)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
        }
    }

    private void addDashboardRoleForEntitlements(CoinUser user, List<String> entitlements) {
        if (entitlements.stream().anyMatch(entitlement -> entitlement.indexOf(this.adminSurfConextIdpRole) > -1)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
        } else if (entitlements.stream().anyMatch(entitlement -> entitlement.indexOf(this.viewerSurfConextIdpRole) > -1)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
        }
    }

    private List<IdentityProvider> getInstitutionIdentityProviders(String idpId) {
        return this.manage.getIdentityProvider(idpId).map(idp -> {
            String institutionId = idp.getInstitutionId();
            return StringUtils.hasText((String)institutionId) ? this.manage.getInstituteIdentityProviders(institutionId) : Collections.singletonList(idp);
        }).orElse(Collections.emptyList());
    }

    private Optional<String> getFirstShibHeaderValue(ShibbolethHeader headerName, HttpServletRequest request) {
        return this.getShibHeaderValues(headerName, request).stream().findFirst();
    }

    private List<String> getShibHeaderValues(ShibbolethHeader headerName, HttpServletRequest request) {
        String headerValue = request.getHeader(headerName.getValue());
        return headerValue == null ? Collections.emptyList() : shibHeaderValueSplitter.splitToList((CharSequence)headerValue);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private IdentityProvider getCurrentIdp(String idpId, List<IdentityProvider> institutionIdentityProviders) {
        return institutionIdentityProviders.stream().filter(provider -> provider.getId().equals(idpId)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The Idp('%s') is not present in the list of Idp's returned by the CsaClient", idpId)));
    }

    public void setDashboardAdmin(String dashboardAdmin) {
        this.dashboardAdmin = dashboardAdmin;
    }

    public void setDashboardViewer(String dashboardViewer) {
        this.dashboardViewer = dashboardViewer;
    }

    public void setDashboardSuperUser(String dashboardSuperUser) {
        this.dashboardSuperUser = dashboardSuperUser;
    }

    public void setAdminSurfConextIdpRole(String adminSurfConextIdpRole) {
        this.adminSurfConextIdpRole = adminSurfConextIdpRole;
    }

    public void setViewerSurfConextIdpRole(String viewerSurfConextIdpRole) {
        this.viewerSurfConextIdpRole = viewerSurfConextIdpRole;
    }

    static {
        shibHeaderValueSplitter = Splitter.on((char)';').omitEmptyStrings();
        LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
        shibHeaders = ImmutableMap.builder().put((Object)"urn:mace:dir:attribute-def:uid", (Object)ShibbolethHeader.Shib_Uid).put((Object)"urn:mace:dir:attribute-def:sn", (Object)ShibbolethHeader.Shib_SurName).put((Object)"urn:mace:dir:attribute-def:givenName", (Object)ShibbolethHeader.Shib_GivenName).put((Object)"urn:mace:dir:attribute-def:cn", (Object)ShibbolethHeader.Shib_CommonName).put((Object)"urn:mace:dir:attribute-def:displayName", (Object)ShibbolethHeader.Shib_DisplayName).put((Object)"urn:mace:dir:attribute-def:mail", (Object)ShibbolethHeader.Shib_Email).put((Object)"urn:mace:dir:attribute-def:eduPersonAffiliation", (Object)ShibbolethHeader.Shib_EduPersonAffiliation).put((Object)"urn:mace:dir:attribute-def:eduPersonScopedAffiliation", (Object)ShibbolethHeader.Shib_EduPersonScopedAffiliation).put((Object)"urn:mace:dir:attribute-def:eduPersonEntitlement", (Object)ShibbolethHeader.Shib_EduPersonEntitlement).put((Object)"urn:mace:dir:attribute-def:isMemberOf", (Object)ShibbolethHeader.Shib_MemberOf).put((Object)"urn:mace:dir:attribute-def:eduPersonPrincipalName", (Object)ShibbolethHeader.Shib_EduPersonPN).put((Object)"urn:mace:dir:attribute-def:preferredLanguage", (Object)ShibbolethHeader.Shib_PreferredLanguage).put((Object)"urn:mace:terena.org:attribute-def:schacHomeOrganization", (Object)ShibbolethHeader.Shib_HomeOrg).put((Object)"urn:mace:terena.org:attribute-def:schacHomeOrganizationType", (Object)ShibbolethHeader.Shib_SchacHomeOrganizationType).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlEduPersonHomeOrganization", (Object)ShibbolethHeader.Shib_NlEduPersonHomeOrganization).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlEduPersonStudyBranch", (Object)ShibbolethHeader.Shib_NlEduPersonStudyBranch).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlStudielinkNummer", (Object)ShibbolethHeader.Shib_NlStudielinkNummer).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlDigitalAuthorIdentifier", (Object)ShibbolethHeader.Shib_NlDigitalAuthorIdentifier).put((Object)"urn:mace:surffederatie_nl:attribute-def:nlEduPersonOrgUnit", (Object)ShibbolethHeader.Shib_NlEduPersonOrgUnit).put((Object)"urn:schac:attribute-def:schacPersonalUniqueCode", (Object)ShibbolethHeader.Shib_SchacPersonalUniqueCode).put((Object)"urn:oid:1.3.6.1.4.1.1076.20.100.10.10.1", (Object)ShibbolethHeader.Shib_UserStatus).put((Object)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (Object)ShibbolethHeader.Shib_Accountstatus).put((Object)"urn:oid:1.3.6.1.4.1.1076.20.100.10.10.2", (Object)ShibbolethHeader.Shib_VoName).build();
    }
}

