/*
 * Decompiled with CFR 0.152.
 */
package selfservice.domain;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.springframework.util.CollectionUtils;
import selfservice.domain.ContactPerson;
import selfservice.domain.ContactPersonType;
import selfservice.domain.Provider;

public abstract class Provider
implements Comparable<Provider>,
Serializable {
    private String id;
    private Long eid;
    private String name;
    private String logoUrl;
    private String publishInEdugainDate;
    private Map<String, String> names = new HashMap();
    private Map<String, String> homeUrls = new HashMap();
    private Map<String, String> descriptions = new HashMap();
    private boolean linked;
    private List<ContactPerson> contactPersons = new ArrayList();
    private boolean allowedAll;
    private Set<String> allowedEntityIds;
    private boolean noConsentRequired;
    private boolean publishedInEdugain;

    public Provider() {
    }

    public Provider(Map<String, Object> metaData) {
        this.id = (String)metaData.get("entityid");
        this.eid = ((Number)metaData.get("eid")).longValue();
        this.addName("en", (String)metaData.get("name:en"));
        this.addName("nl", (String)metaData.get("name:nl"));
        this.name = this.names.isEmpty() ? (String)metaData.get("entityid") : (String)this.names.getOrDefault("en", this.names.get("nl"));
        this.logoUrl = (String)metaData.get("logo:0:url");
        this.addHomeUrl("en", (String)metaData.get("OrganizationURL:en"));
        this.addHomeUrl("nl", (String)metaData.get("OrganizationURL:nl"));
        this.addDescription("en", (String)metaData.get("description:en"));
        this.addDescription("nl", (String)metaData.get("description:nl"));
        IntStream.rangeClosed(0, 2).forEach(i -> {
            String contactType = (String)metaData.get("contacts:" + i + ":contactType");
            if (contactType != null) {
                this.addContactPerson(new ContactPerson(this.safeString((Object)(metaData.get("contacts:" + i + ":givenName") + " " + this.safeString(metaData.get("contacts:" + i + ":surName")))).trim(), (String)metaData.get("contacts:" + i + ":emailAddress"), (String)metaData.get("contacts:" + i + ":telephoneNumber"), this.contactPersonType(contactType), this.booleanValue(metaData.get("contacts:" + i + ":isSirtfiSecurityContact"))));
            }
        });
        this.allowedAll = this.getAllowedAll(metaData);
        this.allowedEntityIds = this.getAllowedEntries(metaData);
        this.noConsentRequired = this.booleanValue(metaData.get("coin:no_consent_required"));
        this.publishedInEdugain = this.booleanValue(metaData.get("coin:publish_in_edugain"));
        this.publishInEdugainDate = (String)metaData.get("coin:publish_in_edugain_date");
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getHomeUrls() {
        return this.homeUrls;
    }

    private void addHomeUrl(String language, String homeUrl) {
        if (homeUrl != null) {
            this.homeUrls.put(language, homeUrl);
        }
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public ContactPerson getContactPerson(ContactPersonType type) {
        if (CollectionUtils.isEmpty((Collection)this.contactPersons)) {
            return null;
        }
        return this.contactPersons.stream().filter(cp -> cp.getContactPersonType().equals((Object)type)).findFirst().orElse(null);
    }

    public void addContactPerson(ContactPerson contactPerson) {
        this.contactPersons.add(contactPerson);
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public String getName(Language language) {
        if (this.names == null) {
            return this.getName();
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.names.get(language.name().toLowerCase())))) {
            return this.getName();
        }
        return (String)this.names.get(language.name().toLowerCase());
    }

    protected void addName(String language, String name) {
        if (name != null) {
            this.names.put(language, name);
        }
    }

    public String getDescription(Language language) {
        if (this.descriptions == null) {
            return null;
        }
        return (String)this.descriptions.get(language.name().toLowerCase());
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public Long getEid() {
        return this.eid;
    }

    public void setEid(Long eid) {
        this.eid = eid;
    }

    private void addDescription(String language, String description) {
        this.descriptions.put(language, description);
    }

    public boolean isNoConsentRequired() {
        return this.noConsentRequired;
    }

    public void setNoConsentRequired(boolean noConsentRequired) {
        this.noConsentRequired = noConsentRequired;
    }

    public boolean isAllowedAll() {
        return this.allowedAll;
    }

    public Set<String> getAllowedEntityIds() {
        return this.allowedEntityIds;
    }

    public String getPublishInEdugainDate() {
        return this.publishInEdugainDate;
    }

    public boolean isPublishedInEdugain() {
        return this.publishedInEdugain;
    }

    protected boolean booleanValue(Object metadataValue) {
        return metadataValue != null && metadataValue.equals("1");
    }

    protected Boolean booleanOptionalValue(Object metadataValue) {
        return metadataValue == null ? null : Boolean.valueOf(metadataValue.equals("1"));
    }

    protected String safeString(Object o) {
        return o != null ? o.toString() : "";
    }

    private ContactPersonType contactPersonType(String contactType) {
        switch (contactType) {
            case "technical": {
                return ContactPersonType.technical;
            }
            case "support": {
                return ContactPersonType.help;
            }
        }
        return ContactPersonType.administrative;
    }

    private Set<String> getAllowedEntries(Map<String, Object> entry) {
        List allowedEntities = entry.getOrDefault("allowedEntities", Collections.emptyList());
        return new HashSet<String>(allowedEntities);
    }

    private boolean getAllowedAll(Map<String, Object> entry) {
        String allowedall = (String)entry.getOrDefault("allowedall", "yes");
        return allowedall.equals("yes");
    }

    @Override
    public int compareTo(Provider that) {
        return new CompareToBuilder().append((Object)StringUtils.lowerCase((String)this.name), (Object)StringUtils.lowerCase((String)that.name)).toComparison();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Provider provider = (Provider)o;
        return Objects.equals(this.id, provider.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("names", (Object)this.names).add("id", (Object)this.getId()).add("contactPersons", (Object)this.contactPersons).add("descriptions", (Object)this.descriptions).toString();
    }
}

