/*
 * Decompiled with CFR 0.152.
 */
package selfservice.manage;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import selfservice.domain.IdentityProvider;
import selfservice.domain.ServiceProvider;
import selfservice.manage.EntityType;
import selfservice.manage.Manage;

public class UrlResourceManage
implements Manage {
    private static final Logger LOG = LoggerFactory.getLogger(UrlResourceManage.class);
    private final String manageBaseUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders httpHeaders;
    private String requestedAttributes = "\"state\":\"prodaccepted\",\"ALL_ATTRIBUTES\":true";
    private String body = "{" + this.requestedAttributes + "}";
    private String bodyForEntity = "{\"entityid\":\"@@entityid@@\", " + this.requestedAttributes + "}";
    private String bodyForEid = "{\"eid\":@@eid@@, " + this.requestedAttributes + "}";
    private String bodyForInstitutionId = "{\"metaDataFields.coin:institution_id\":\"@@institution_id@@\", \"ALL_ATTRIBUTES\":true}";
    private String linkedQuery = "{$and: [{$or:[{\"data.allowedEntities.name\": {$in: [\"@@entityid@@\"]}}, {\"data.allowedall\": true}]}, {\"data.state\":\"prodaccepted\"}]}";

    public UrlResourceManage(String username, String password, String manageBaseUrl) {
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode((username + ":" + password).getBytes()));
        this.manageBaseUrl = manageBaseUrl;
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.add("Content-Type", "application/json");
        this.httpHeaders.add("Authorization", basicAuth);
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        requestFactory.setConnectTimeout(10000);
    }

    public List<ServiceProvider> getAllServiceProviders() {
        List providers = this.getMaps(this.getSpInputStream(this.body));
        List singleTenants = this.getMaps(this.getSingleTenantInputStream(this.body));
        List<ServiceProvider> serviceProviders = providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.saml20_sp)).filter(sp -> !sp.isHidden()).collect(Collectors.toList());
        List<ServiceProvider> singleTenantsProviders = singleTenants.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.single_tenant_template)).collect(Collectors.toList());
        singleTenantsProviders.forEach(tenant -> tenant.setExampleSingleTenant(true));
        serviceProviders.addAll(singleTenantsProviders);
        return serviceProviders;
    }

    public Optional<ServiceProvider> getServiceProvider(String spEntityId, EntityType type, boolean searchRevisions) {
        if (StringUtils.isEmpty((Object)spEntityId)) {
            return Optional.empty();
        }
        String body = this.bodyForEntity.replace("@@entityid@@", spEntityId);
        InputStream inputStream = type.equals((Object)EntityType.saml20_sp) ? this.getSpInputStream(body) : this.getSingleTenantInputStream(body);
        List providers = this.getMaps(inputStream);
        if (providers.isEmpty()) {
            providers = this.getMaps(this.getSpRevisionInputStream(body));
        }
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, type)).findFirst();
    }

    public Optional<ServiceProvider> getServiceProviderById(Long spId, EntityType entityType) {
        if (spId == null) {
            return Optional.empty();
        }
        String body = this.bodyForEid.replace("@@eid@@", spId.toString());
        InputStream inputStream = entityType.equals((Object)EntityType.saml20_sp) ? this.getSpInputStream(body) : this.getSingleTenantInputStream(body);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, entityType)).findFirst();
    }

    public Optional<IdentityProvider> getIdentityProvider(String idpEntityId, boolean searchRevisions) {
        if (StringUtils.isEmpty((Object)idpEntityId)) {
            return Optional.empty();
        }
        String body = this.bodyForEntity.replace("@@entityid@@", idpEntityId);
        InputStream inputStream = this.getIdpInputStream(body);
        List providers = this.getMaps(inputStream);
        if (providers.isEmpty()) {
            providers = this.getMaps(this.getIdpRevisionInputStream(body));
        }
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).findFirst();
    }

    public List<IdentityProvider> getInstituteIdentityProviders(String instituteId) {
        String body = this.bodyForInstitutionId.replace("@@institution_id@@", instituteId);
        InputStream inputStream = this.getIdpInputStream(body);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<IdentityProvider> getAllIdentityProviders() {
        InputStream inputStream = this.getIdpInputStream(this.body);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<IdentityProvider> getLinkedIdentityProviders(String spId) {
        String replaced = this.linkedQuery.replace("@@entityid@@", spId);
        InputStream inputStream = this.searchIdp(replaced);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<ServiceProvider> getInstitutionalServicesForIdp(String instituteId) {
        String body = this.bodyForInstitutionId.replace("@@institution_id@@", instituteId);
        InputStream inputStream = this.getSpInputStream(body);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.saml20_sp)).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getMaps(InputStream inputStream) {
        try {
            return (List)objectMapper.readValue(inputStream, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getIdpInputStream(String body) {
        return this.getIdpInputStreamFromCollection(body, "saml20_idp");
    }

    private InputStream getIdpRevisionInputStream(String body) {
        return this.getIdpInputStreamFromCollection(body, "saml20_idp_revision");
    }

    private InputStream getIdpInputStreamFromCollection(String body, String collection) {
        LOG.debug("Fetching IDP metadata entries from {} with body {}", (Object)this.manageBaseUrl);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + collection, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSpInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "saml20_sp");
    }

    private InputStream getSpRevisionInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "saml20_sp_revision");
    }

    private InputStream getSpInputStreamFromCollection(String body, String collection) {
        LOG.debug("Fetching SP metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + collection, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream searchIdp(String query) {
        String url;
        LOG.debug("Quering IdP metadata entries from {} with query {}", (Object)this.manageBaseUrl, (Object)this.body);
        try {
            url = this.manageBaseUrl + "/manage/api/internal/rawSearch/saml20_idp?query=" + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSingleTenantInputStream(String body) {
        LOG.debug("Fetching Single Tenant Templates metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/single_tenant_template", HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }
}

