/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.dashboard;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import selfservice.api.dashboard.BaseController;
import selfservice.api.dashboard.RestResponse;
import selfservice.domain.Action;
import selfservice.domain.Change;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.ContactPerson;
import selfservice.domain.IdentityProvider;
import selfservice.domain.Provider;
import selfservice.domain.Service;
import selfservice.domain.Settings;
import selfservice.manage.Manage;
import selfservice.service.ActionsService;
import selfservice.service.Services;
import selfservice.util.SpringSecurity;

@RestController
@RequestMapping(value={"/dashboard/api/users"}, produces={"application/json"})
public class UsersController
extends BaseController {
    @Autowired
    private Manage manage;
    @Autowired
    private Services services;
    @Autowired
    private ActionsService actionsService;
    private static final Logger LOG = LoggerFactory.getLogger(UsersController.class);

    @RequestMapping(value={"/me"})
    public RestResponse<CoinUser> me() {
        return this.createRestResponse((Object)SpringSecurity.getCurrentUser());
    }

    @RequestMapping(value={"/super/idps"})
    public ResponseEntity<RestResponse<Map<String, List<?>>>> idps() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (!currentUser.isSuperUser()) {
            LOG.warn("IdP's endpoint is only allowed for superUser, not for {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        List idps = this.manage.getAllIdentityProviders().stream().sorted(Comparator.comparing(Provider::getName)).collect(Collectors.toList());
        List<String> roles = Arrays.asList(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER.name(), CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN.name());
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("idps", idps);
        payload.put("roles", roles);
        return new ResponseEntity((Object)this.createRestResponse(payload), HttpStatus.OK);
    }

    @RequestMapping(value={"/me/serviceproviders"}, method={RequestMethod.GET})
    public RestResponse<List<Service>> serviceProviders(Locale locale) throws IOException {
        List usersServices = this.getServiceProvidersForCurrentUser(locale);
        return this.createRestResponse((Object)usersServices);
    }

    private List<Service> getServiceProvidersForCurrentUser(Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        Optional switchedToIdp = currentUser.getSwitchedToIdp();
        String usersInstitutionId = switchedToIdp.isPresent() ? ((IdentityProvider)switchedToIdp.get()).getInstitutionId() : currentUser.getInstitutionId();
        return Strings.isNullOrEmpty((String)usersInstitutionId) ? Collections.emptyList() : this.services.getInstitutionalServicesForIdp(usersInstitutionId, locale);
    }

    @RequestMapping(value={"/me/switch-to-idp"})
    public ResponseEntity<Void> currentIdp(@RequestParam(value="idpId", required=false) String switchToIdp, @RequestParam(value="role", required=false) String role, HttpServletResponse response) {
        if (Strings.isNullOrEmpty((String)switchToIdp)) {
            SpringSecurity.clearSwitchedIdp();
        } else {
            IdentityProvider identityProvider = (IdentityProvider)this.manage.getIdentityProvider(switchToIdp, false).orElseThrow(() -> new SecurityException(switchToIdp + " does not exist"));
            SpringSecurity.setSwitchedToIdp((IdentityProvider)identityProvider, (String)role);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/me/settings"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateSettings(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale, @RequestBody Settings settings) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            LOG.warn("Settings endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getIdp();
        ArrayList changes = new ArrayList();
        String idpId = idp.getId();
        this.diff(changes, idpId, idp.getKeywords().get("en"), (Object)settings.getKeywordsEn(), "keywords:en");
        this.diff(changes, idpId, idp.getKeywords().get("nl"), (Object)settings.getKeywordsNl(), "keywords:nl");
        this.diff(changes, idpId, idp.getDescriptions().get("en"), (Object)settings.getDescriptionsEn(), "description:en");
        this.diff(changes, idpId, idp.getDescriptions().get("nl"), (Object)settings.getDescriptionsNl(), "description:nl");
        this.diff(changes, idpId, idp.getDisplayNames().get("en"), (Object)settings.getDisplayNamesEn(), "displayName:en");
        this.diff(changes, idpId, idp.getDisplayNames().get("nl"), (Object)settings.getDisplayNamesNl(), "displayName:nl");
        this.diff(changes, idpId, (Object)idp.isPublishedInEdugain(), (Object)settings.isPublishedInEdugain(), "coi:publish_in_edugain");
        this.diff(changes, idpId, (Object)idp.isConnectToRSServicesAutomatically(), (Object)settings.isConnectToRSServicesAutomatically(), "coin:entity_categories:1 - http://refeds.org/category/research-and-scholarship");
        this.diff(changes, idpId, (Object)idp.getLogoUrl(), (Object)settings.getLogoUrl(), "logo:0:url");
        this.diff(changes, idpId, (Object)idp.getState(), (Object)settings.getStateType().name(), "state");
        this.diffContactPersons(changes, idpId, idp.getContactPersons(), settings.getContactPersons());
        List serviceProviders = this.getServiceProvidersForCurrentUser(locale);
        settings.getServiceProviderSettings().forEach(sp -> {
            Optional<Service> first = serviceProviders.stream().filter(service -> service.getSpEntityId().equals(sp.getSpEntityId())).findFirst();
            first.ifPresent(service -> {
                String id = service.getSpEntityId();
                this.diff(changes, id, (Object)sp.getDescriptionEn(), service.getDescriptions().get("en"), "description:en");
                this.diff(changes, id, (Object)sp.getDescriptionNl(), service.getDescriptions().get("nl"), "description:nl");
                this.diff(changes, id, (Object)sp.getDisplayNameEn(), service.getDisplayNames().get("en"), "displayName:en");
                this.diff(changes, id, (Object)sp.getDisplayNameNl(), service.getDisplayNames().get("nl"), "displayName:nl");
                this.diff(changes, id, (Object)sp.isPublishedInEdugain(), (Object)service.isPublishedInEdugain(), "coin:publish_in_edugain");
                this.diff(changes, id, (Object)sp.isHasGuestEnabled(), (Object)service.isGuestEnabled(), "Guest Login Enabled");
                this.diff(changes, id, (Object)sp.isNoConsentRequired(), (Object)service.isNoConsentRequired(), "coin:no_consent_required");
                this.diff(changes, idpId, (Object)sp.getStateType().name(), (Object)service.getState(), "state");
                this.diffContactPersons(changes, id, sp.getContactPersons(), service.getContactPersons());
            });
        });
        if (changes.isEmpty()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).settings(settings).type(Action.Type.CHANGE).build();
        this.actionsService.create(action, changes);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    private void diffContactPersons(List<Change> changes, String id, List<ContactPerson> contactPersons, List<ContactPerson> newContactPersons) {
        for (int i = 0; i < contactPersons.size(); ++i) {
            ContactPerson contactPerson = contactPersons.get(i);
            if (newContactPersons == null || newContactPersons.size() < i + 1) continue;
            ContactPerson newContactPerson = newContactPersons.get(i);
            this.diff(changes, id, (Object)contactPerson.getName(), (Object)newContactPerson.getName(), "contacts:" + i + ":name");
            this.diff(changes, id, (Object)contactPerson.getEmailAddress(), (Object)newContactPerson.getEmailAddress(), "contacts:" + i + ":emailAddress");
            this.diff(changes, id, (Object)contactPerson.getTelephoneNumber(), (Object)newContactPerson.getTelephoneNumber(), "contacts:" + i + ":telephoneNumber");
            this.diff(changes, id, (Object)contactPerson.getContactPersonType(), (Object)newContactPerson.getContactPersonType(), "contacts:" + i + ":contactType");
        }
    }

    private void diff(List<Change> changes, String id, Object oldValue, Object newValue, String attributeName) {
        if (this.changed(oldValue, newValue)) {
            changes.add(new Change(id, attributeName, String.format("%s", oldValue), String.format("%s", oldValue)));
        }
    }

    private boolean changed(Object oldValue, Object newValue) {
        boolean newNotNull;
        boolean oldNotNull;
        boolean bl = oldValue instanceof String ? StringUtils.hasText((String)((String)oldValue)) : (oldNotNull = oldValue != null);
        boolean bl2 = newValue instanceof String ? StringUtils.hasText((String)((String)newValue)) : (newNotNull = newValue != null);
        if (!oldNotNull && !newNotNull) {
            return false;
        }
        if (oldNotNull && !newNotNull) {
            return true;
        }
        if (!oldNotNull && newNotNull) {
            return true;
        }
        return !oldValue.equals(newValue);
    }
}

