/*
 * Decompiled with CFR 0.152.
 */
package selfservice.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;
import selfservice.domain.CoinAuthority;
import selfservice.domain.IdentityProvider;
import selfservice.shibboleth.ShibbolethHeader;

public class CoinUser
implements UserDetails {
    private String uid;
    private String displayName;
    private String schacHomeOrganization;
    private IdentityProvider currentIdp;
    private IdentityProvider switchedToIdp;
    private List<IdentityProvider> institutionIdps = new ArrayList();
    private String institutionId;
    private String email;
    private Set<CoinAuthority> grantedAuthorities = new HashSet();
    private Map<ShibbolethHeader, List<String>> attributeMap = new HashMap();

    @JsonIgnore
    public String getPassword() {
        return "";
    }

    public String getUsername() {
        return this.uid;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSuperUser() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER));
    }

    public boolean isDashboardAdmin() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
    }

    public boolean isDashboardViewer() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public void setSchacHomeOrganization(String schacHomeOrganization) {
        this.schacHomeOrganization = schacHomeOrganization;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedAuthorities;
    }

    public void setAuthorities(Set<CoinAuthority> grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
    }

    public void addAuthority(CoinAuthority grantedAuthority) {
        this.grantedAuthorities.add(grantedAuthority);
    }

    public void removeAuthority(CoinAuthority grantedAuthority) {
        this.grantedAuthorities.remove(grantedAuthority);
    }

    public boolean hasAuthority(CoinAuthority grantedAuthority) {
        return this.grantedAuthorities.contains(grantedAuthority);
    }

    public String getFriendlyName() {
        return StringUtils.hasText((String)this.displayName) ? this.displayName : this.uid;
    }

    public List<IdentityProvider> getInstitutionIdps() {
        return this.institutionIdps;
    }

    public void addInstitutionIdp(IdentityProvider idp) {
        this.institutionIdps.add(idp);
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public IdentityProvider getIdp() {
        return this.currentIdp;
    }

    public void setIdp(IdentityProvider idp) {
        this.currentIdp = idp;
    }

    public Optional<IdentityProvider> getSwitchedToIdp() {
        return Optional.ofNullable(this.switchedToIdp);
    }

    public void setSwitchedToIdp(IdentityProvider switchedToIdp) {
        this.switchedToIdp = switchedToIdp;
    }

    public Map<ShibbolethHeader, List<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<ShibbolethHeader, List<String>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void addAttribute(ShibbolethHeader key, List<String> value) {
        this.attributeMap.put(key, value);
    }

    public List<CoinAuthority.Authority> getAuthorityEnums() {
        return this.grantedAuthorities.stream().map(CoinAuthority::getEnumAuthority).collect(Collectors.toList());
    }

    public Optional<IdentityProvider> getByEntityId(String entityId) {
        return this.getInstitutionIdps().stream().filter(iip -> iip.getId().equals(entityId)).findFirst();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uid", (Object)this.uid).add("displayName", (Object)this.displayName).add("schacHomeOrganization", (Object)this.schacHomeOrganization).add("idp", (Object)this.currentIdp).add("institutionIdps", (Object)this.institutionIdps).add("institutionId", (Object)this.institutionId).add("email", (Object)this.email).add("grantedAuthorities", (Object)this.grantedAuthorities).add("attributeMap", (Object)this.attributeMap).add("switchedToIdp", (Object)this.switchedToIdp).toString();
    }
}

