/*
 * Decompiled with CFR 0.152.
 */
package selfservice.domain;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import selfservice.domain.Provider;

public class IdentityProvider
extends Provider
implements Serializable {
    private String institutionId;
    private Map<String, String> keywords = new HashMap();
    private boolean connectToRSServicesAutomatically;

    public IdentityProvider() {
    }

    public IdentityProvider(String id, String institutionId, String name, Long eid) {
        this.setId(id);
        this.setEid(eid);
        this.institutionId = institutionId;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.setName(name);
            this.addName("en", name);
            this.addName("nl", name);
        }
    }

    public IdentityProvider(Map<String, Object> metaData) {
        super(metaData);
        this.institutionId = (String)metaData.get("coin:institution_id");
        this.addKeywords("en", (String)metaData.get("keywords:en"));
        this.addKeywords("nl", (String)metaData.get("keywords:nl"));
        this.connectToRSServicesAutomatically = "http://refeds.org/category/research-and-scholarship".equals(metaData.get("coin:entity_categories:1"));
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public Map<String, String> getKeywords() {
        return this.keywords;
    }

    private void addKeywords(String language, String keywords) {
        if (keywords != null) {
            this.keywords.put(language, keywords);
        }
    }

    public boolean isConnectToRSServicesAutomatically() {
        return this.connectToRSServicesAutomatically;
    }

    public String toString() {
        return "IdentityProvider{id='" + this.getId() + '\'' + ", institutionId='" + this.institutionId + '\'' + '}';
    }
}

