/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.dashboard;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import selfservice.api.dashboard.BaseController;
import selfservice.api.dashboard.RestResponse;
import selfservice.domain.IdentityProvider;
import selfservice.sab.Sab;
import selfservice.sab.SabPerson;
import selfservice.util.SpringSecurity;

@Controller
@RequestMapping(value={"/dashboard/api/idp"}, produces={"application/json"})
public class IdpController
extends BaseController {
    public static final List<String> INTERESTING_ROLES = ImmutableList.of((Object)"SURFconextbeheerder", (Object)"SURFconextverantwoordelijke");
    @Autowired
    private Sab sabClient;

    @RequestMapping(value={"/current/roles"})
    public ResponseEntity<RestResponse<Map<String, Collection<SabPerson>>>> roles(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId) {
        Map roleAssignments = SpringSecurity.getCurrentUser().getByEntityId(idpEntityId).map(arg_0 -> this.personsInRole(arg_0)).orElse((Map)ImmutableMap.of());
        return new ResponseEntity((Object)this.createRestResponse((Object)roleAssignments), HttpStatus.OK);
    }

    private Map<String, Collection<SabPerson>> personsInRole(IdentityProvider idp) {
        if (Strings.isNullOrEmpty((String)idp.getInstitutionId())) {
            return ImmutableMap.of();
        }
        return INTERESTING_ROLES.stream().collect(Collectors.toMap(Function.identity(), role -> this.sabClient.getPersonsInRoleForOrganization(idp.getInstitutionId(), role)));
    }
}

