/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.dashboard;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import selfservice.api.dashboard.BaseController;
import selfservice.api.dashboard.RestResponse;
import selfservice.domain.Action;
import selfservice.domain.Category;
import selfservice.domain.CategoryValue;
import selfservice.domain.CoinUser;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.domain.Provider;
import selfservice.domain.Service;
import selfservice.manage.EntityType;
import selfservice.manage.Manage;
import selfservice.service.ActionsService;
import selfservice.service.Services;
import selfservice.util.SpringSecurity;

@RestController
@RequestMapping(value={"/dashboard/api/services"}, produces={"application/json"})
public class ServicesController
extends BaseController {
    private static Set<String> IGNORED_ARP_LABELS = ImmutableSet.of((Object)"urn:mace:dir:attribute-def:eduPersonTargetedID");
    @Autowired
    private Services services;
    @Autowired
    private Manage manage;
    @Autowired
    private ActionsService actionsService;

    @RequestMapping
    public RestResponse<Map<String, Object>> index(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale) throws IOException {
        List servicesForIdp = this.services.getServicesForIdp(idpEntityId, locale);
        List categories = this.getCategories(servicesForIdp);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("apps", servicesForIdp);
        result.put("facets", categories);
        return this.createRestResponse(result);
    }

    private List<Category> getCategories(List<Service> servicesForIdp) {
        Map<String, List<Category>> groupedCategories = servicesForIdp.stream().map(s -> s.getCategories()).flatMap(Collection::stream).collect(Collectors.groupingBy(Category::getName));
        return groupedCategories.entrySet().stream().map(entry -> {
            List categoryValues = ((List)entry.getValue()).stream().map(cat -> cat.getValues().stream().map(CategoryValue::getValue)).flatMap(Function.identity()).collect(Collectors.toSet()).stream().map(CategoryValue::new).collect(Collectors.toList());
            return new Category((String)entry.getKey(), categoryValues);
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/connected"})
    public RestResponse<List<Service>> connected(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale) throws IOException {
        return this.createRestResponse(this.services.getServicesForIdp(idpEntityId, locale).stream().filter(Service::isConnected).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/idps"})
    public RestResponse<List<InstitutionIdentityProvider>> getConnectedIdps(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam String spEntityId) {
        List idps = this.manage.getLinkedIdentityProviders(spEntityId).stream().map(idp -> new InstitutionIdentityProvider(idp.getId(), idp.getName(Provider.Language.EN), idp.getName(Provider.Language.NL), idp.getInstitutionId())).collect(Collectors.toList());
        return this.createRestResponse(idps);
    }

    @RequestMapping(value={"/download"})
    public ResponseEntity<Void> download(@RequestParam(value="idpEntityId") String idpEntityId, @RequestParam(value="ids") String idCommaSeperated, Locale locale, HttpServletResponse response) throws IOException {
        List services = this.services.getServicesForIdp(idpEntityId, locale);
        List ids = Arrays.asList(idCommaSeperated.split(",")).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toList());
        Stream<String[]> values = ids.stream().map(id -> this.getServiceById(services, id)).flatMap(opt -> opt.map(Stream::of).orElse(Stream.empty())).map(service -> new String[]{String.valueOf(service.getId()), this.stripBreakingWhitespace(service.getName()), service.getSpEntityId(), this.stripBreakingWhitespace(service.getDescription()), service.getAppUrl(), service.getWikiUrl(), service.getSupportMail(), String.valueOf(service.isConnected()), service.getLicenseStatus().name(), String.valueOf(service.isPublishedInEdugain()), String.valueOf(service.isExampleSingleTenant()), String.valueOf(service.isStrongAuthentication()), String.valueOf(!service.getArp().isNoArp()), service.getArp().getAttributes().keySet().stream().collect(Collectors.joining(" - "))});
        Stream<String[]> headers = Stream.of(new String[]{"id", "name", "entityID", "description", "app-url", "wiki-url", "support-mail", "connected", "licenseStatus", "publishedInEdugain", "singleTenant", "strongAuthentication", "arpEnabled", "arpAttributes"});
        List rows = Stream.concat(headers, values).collect(Collectors.toList());
        response.setHeader("Content-Disposition", String.format("attachment; filename=service-overview.csv", new Object[0]));
        try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            writer.writeAll(rows);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return ResponseEntity.ok().build();
    }

    private String stripBreakingWhitespace(String input) {
        return StringUtils.hasText((String)input) ? input.trim().replace("\n", "") : "";
    }

    private Optional<Service> getServiceById(List<Service> services, Long id) {
        return services.stream().filter(service -> service.getId() == id.longValue()).findFirst();
    }

    @RequestMapping(value={"/detail"})
    public ResponseEntity<RestResponse<Service>> get(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam Long spId, @RequestParam String entityType, Locale locale) throws IOException {
        Optional serviceByEntityId = this.services.getServiceById(idpEntityId, spId, EntityType.valueOf((String)entityType), locale);
        return serviceByEntityId.map(arg_0 -> this.removeExplicitlyUnusedArpLabels(arg_0)).map(service -> ResponseEntity.ok((Object)this.createRestResponse(service))).orElse(new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    private Service removeExplicitlyUnusedArpLabels(Service service) {
        if (service.getArp() == null) {
            return service;
        }
        IGNORED_ARP_LABELS.forEach(label -> {
            List cfr_ignored_0 = (List)service.getArp().getAttributes().remove(label);
        });
        return service;
    }

    @RequestMapping(value={"/connect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Action>> connect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="spEntityId") String spEntityId, Locale locale) throws IOException {
        return this.createAction(idpEntityId, comments, spEntityId, Action.Type.LINKREQUEST, locale).map(action -> ResponseEntity.ok((Object)this.createRestResponse(action))).orElse(new ResponseEntity(HttpStatus.FORBIDDEN));
    }

    @RequestMapping(value={"/disconnect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Action>> disconnect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="spEntityId") String spEntityId, Locale locale) throws IOException {
        return this.createAction(idpEntityId, comments, spEntityId, Action.Type.UNLINKREQUEST, locale).map(action -> ResponseEntity.ok((Object)this.createRestResponse(action))).orElse(new ResponseEntity(HttpStatus.FORBIDDEN));
    }

    private Optional<Action> createAction(String idpEntityId, String comments, String spEntityId, Action.Type jiraType, Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)currentUser.getIdp().getInstitutionId())) {
            return Optional.empty();
        }
        List services = this.services.getServicesForIdp(idpEntityId, locale);
        Optional<Service> optional = services.stream().filter(s -> s.getSpEntityId().equals(spEntityId)).findFirst();
        if (optional.isPresent()) {
            Service service = optional.get();
            Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).body(comments).idpId(idpEntityId).spId(spEntityId).service(service).type(jiraType).build();
            return Optional.of(this.actionsService.create(action, Collections.emptyList()));
        }
        return Optional.empty();
    }
}

