/*
 * Decompiled with CFR 0.152.
 */
package selfservice.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import selfservice.domain.Action;
import selfservice.domain.Change;
import selfservice.service.impl.JiraClient;
import selfservice.service.impl.JiraTicketSummaryAndDescriptionBuilder;

public class JiraClientImpl
implements JiraClient {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClientImpl.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String SP_CUSTOM_FIELD = "13018";
    private static final String IDP_CUSTOM_FIELD = "13012";
    private static final String DEFAULT_SECURITY_LEVEL_ID = "10100";
    private static final String PRIORITY_MEDIUM_ID = "3";
    private static final Map<Action.Type, String> TASKTYPE_TO_ISSUETYPE_CODE = ImmutableMap.of((Object)Action.Type.QUESTION, (Object)"11103", (Object)Action.Type.LINKREQUEST, (Object)"11104", (Object)Action.Type.UNLINKREQUEST, (Object)"11105", (Object)Action.Type.CHANGE, (Object)"11106");
    private final String baseUrl;
    private final RestTemplate restTemplate;
    private final String projectKey;
    private final HttpHeaders defaultHeaders;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JiraClientImpl(String baseUrl, String username, String password, String projectKey) {
        this.projectKey = projectKey;
        this.baseUrl = baseUrl;
        this.defaultHeaders = new HttpHeaders();
        this.defaultHeaders.setContentType(MediaType.APPLICATION_JSON);
        byte[] encoded = Base64.encode((byte[])(username + ":" + password).getBytes());
        this.defaultHeaders.add("Authorization", "Basic " + new String(encoded));
        this.restTemplate = new RestTemplate();
    }

    public String create(Action action, List<Change> changes) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("priority", ImmutableMap.of((Object)"id", (Object)PRIORITY_MEDIUM_ID));
        fields.put("project", ImmutableMap.of((Object)"key", (Object)this.projectKey));
        fields.put("customfield_13018", action.getSpId());
        fields.put("customfield_13012", action.getIdpId());
        fields.put("issuetype", ImmutableMap.of((Object)"id", TASKTYPE_TO_ISSUETYPE_CODE.get(action.getType())));
        JiraTicketSummaryAndDescriptionBuilder.SummaryAndDescription summaryAndDescription = JiraTicketSummaryAndDescriptionBuilder.build((Action)action, changes);
        fields.put("summary", summaryAndDescription.summary);
        fields.put("description", summaryAndDescription.description);
        HashMap<String, HashMap<String, Object>> issue = new HashMap<String, HashMap<String, Object>>();
        issue.put("fields", fields);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending JSON {} to JIRA", (Object)this.objectMapper.writeValueAsString(issue));
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        HttpEntity entity = new HttpEntity(issue, (MultiValueMap)this.defaultHeaders);
        try {
            Map result = (Map)this.restTemplate.postForObject(this.baseUrl + "/issue", (Object)entity, Map.class, new Object[0]);
            return (String)result.get("key");
        }
        catch (HttpClientErrorException e) {
            LOG.error("Failed to create Jira issue: {} ({}) with response:\n{}", new Object[]{e.getStatusCode(), e.getStatusText(), e.getResponseBodyAsString()});
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Map<String, Object> getTasks(String idp, int startAt, int maxResults) {
        String query = this.buildQueryForIdp(idp, TASKTYPE_TO_ISSUETYPE_CODE.values());
        try {
            HttpEntity entity = new HttpEntity((Object)ImmutableMap.of((Object)"jql", (Object)query, (Object)"maxResults", (Object)String.valueOf(maxResults)), (MultiValueMap)this.defaultHeaders);
            Map result = (Map)this.restTemplate.postForObject(this.baseUrl + "/search?expand=all", (Object)entity, Map.class, new Object[0]);
            List issues = ((List)result.get("issues")).stream().map(issue -> {
                Map fields = (Map)issue.get("fields");
                String issueType = (String)((Map)fields.get("issuetype")).get("id");
                return Action.builder().jiraKey((String)issue.get("key")).idpId(Optional.ofNullable((String)fields.get("customfield_13012")).orElse("")).spId(Optional.ofNullable((String)fields.get("customfield_13018")).orElse("")).status((String)((Map)fields.get("status")).get("name")).type(this.findType(issueType)).requestDate(ZonedDateTime.parse((String)fields.get("created"), DATE_FORMATTER)).body((String)fields.get("description")).build();
            }).collect(Collectors.toList());
            HashMap<String, Object> answer = new HashMap<String, Object>();
            answer.put("issues", issues);
            answer.put("total", result.get("total"));
            answer.put("startAt", result.get("startAt"));
            answer.put("maxResults", result.get("maxResults"));
            return answer;
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST)) {
                LOG.error("The Jira query \"{}\" was invalid:\n{}", (Object)query, (Object)e.getResponseBodyAsString());
            } else {
                LOG.error("Jira returned a {} ({}) for query {}:\n{}", new Object[]{e.getStatusCode(), e.getStatusText(), query, e.getResponseBodyAsString()});
            }
        }
        catch (RestClientException e) {
            LOG.error("Error communicating with Jira", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private Action.Type findType(String issueType) {
        Action.Type type = TASKTYPE_TO_ISSUETYPE_CODE.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(issueType)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new RuntimeException("no issue type for " + issueType));
        return type;
    }

    private String buildQueryForIdp(String idp, Collection<String> issueTypeIds) {
        return String.format("project = %s AND issueType IN (%s) AND cf[%s]~\"%s\" ORDER BY created DESC", this.projectKey, issueTypeIds.stream().collect(Collectors.joining(", ")), IDP_CUSTOM_FIELD, idp);
    }
}

