/*
 * Decompiled with CFR 0.152.
 */
package selfservice.sab;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import selfservice.sab.SabTransport;

@Component
public class HttpClientTransport
implements SabTransport {
    private final HttpClient httpClient;
    private final UsernamePasswordCredentials samlCredentials;
    private final UsernamePasswordCredentials restCredentials;
    private final URI sabEndpoint;
    private final URI restEndPoint;

    @Autowired
    public HttpClientTransport(@Value(value="${sab.username}") String sabUserName, @Value(value="${sab.password}") String sabPassword, @Value(value="${sab-rest.username}") String sabRestUserName, @Value(value="${sab-rest.password}") String sabRestPassword, @Value(value="${sab.endpoint}") URI sabEndpoint, @Value(value="${sab-rest.endpoint}") URI restEndPoint) {
        this.samlCredentials = new UsernamePasswordCredentials(sabUserName, sabPassword);
        this.restCredentials = new UsernamePasswordCredentials(sabRestUserName, sabRestPassword);
        this.sabEndpoint = sabEndpoint;
        this.restEndPoint = restEndPoint;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
    }

    public InputStream getResponse(String request) throws IOException {
        HttpUriRequest httpRequest = RequestBuilder.post().setUri(this.sabEndpoint).setEntity((HttpEntity)new StringEntity(request)).build();
        return this.handleRequest(httpRequest, this.samlCredentials);
    }

    public InputStream getRestResponse(String organisationAbbreviation, String role) throws IOException {
        HttpGet httpGet = new HttpGet(String.format("%s/profile?abbrev=%s&role=%s", this.restEndPoint, URLEncoder.encode(organisationAbbreviation, "UTF-8"), URLEncoder.encode(role, "UTF-8")));
        return this.handleRequest((HttpUriRequest)httpGet, this.restCredentials);
    }

    private InputStream handleRequest(HttpUriRequest request, UsernamePasswordCredentials credentials) throws IOException {
        request.addHeader("Authorization", "Basic " + this.encodeUserPass(credentials));
        HttpResponse response = this.httpClient.execute(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Failed response: " + response.getStatusLine());
        }
        return response.getEntity().getContent();
    }

    private String encodeUserPass(UsernamePasswordCredentials credentials) {
        return new String(Base64.encodeBase64((byte[])String.format("%s:%s", credentials.getUserName(), credentials.getPassword()).getBytes()));
    }
}

