/*
 * Decompiled with CFR 0.152.
 */
package selfservice.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import selfservice.domain.ARP;
import selfservice.domain.LicenseStatus;
import selfservice.domain.PrivacyInfo;
import selfservice.domain.Provider;

public class ServiceProvider
extends Provider
implements Serializable,
Cloneable {
    private Map<String, String> arpMotivations;
    private String applicationUrl;
    private String institutionId;
    private String eulaURL;
    private String interfedSource;
    private String privacyStatementUrlEn;
    private String privacyStatementUrlNl;
    private String registrationInfo;
    private String registrationPolicyUrlEn;
    private String registrationPolicyUrlNl;
    private String entityCategories1;
    private String entityCategories2;
    private boolean idpVisibleOnly;
    private boolean policyEnforcementDecisionRequired;
    private boolean exampleSingleTenant;
    private boolean aansluitovereenkomstRefused;
    private boolean hidden;
    private LicenseStatus licenseStatus;
    private ARP arp;
    private PrivacyInfo privacyInfo;
    private Map<String, String> urls = new HashMap();
    private String wikiUrlNl;
    private String wikiUrlEn;
    private boolean strongAuthenticationSupported;
    private List<String> typeOfServicesNl = new ArrayList();
    private List<String> typeOfServicesEn = new ArrayList();
    private String manipulationNotes;
    private boolean manipulation;

    public ServiceProvider(Map<String, Object> metaData) {
        super(metaData);
        this.applicationUrl = (String)metaData.get("coin:application_url");
        this.institutionId = (String)metaData.get("coin:institution_id");
        this.eulaURL = (String)metaData.get("coin:eula");
        this.interfedSource = (String)metaData.getOrDefault("coin:interfed_source", "SURFconext");
        this.privacyStatementUrlEn = (String)metaData.get("mdui:PrivacyStatementURL:en");
        this.privacyStatementUrlNl = (String)metaData.get("mdui:PrivacyStatementURL:nl");
        this.registrationInfo = (String)metaData.get("mdrpi:RegistrationInfo");
        this.registrationPolicyUrlEn = (String)metaData.get("mdrpi:RegistrationPolicy:en");
        this.registrationPolicyUrlNl = (String)metaData.get("mdrpi:RegistrationPolicy:nl");
        this.entityCategories1 = (String)metaData.get("coin:entity_categories:1");
        this.entityCategories2 = (String)metaData.get("coin:entity_categories:2");
        this.licenseStatus = LicenseStatus.fromManage((String)((String)metaData.get("coin:ss:license_status")));
        this.idpVisibleOnly = this.booleanValue(metaData.get("coin:ss:idp_visible_only"));
        this.policyEnforcementDecisionRequired = this.booleanValue(metaData.get("coin:policy_enforcement_decision_required"));
        this.strongAuthenticationSupported = this.booleanValue(metaData.get("coin:ss:supports_strong_authentication"));
        this.aansluitovereenkomstRefused = this.booleanValue(metaData.get("coin:ss:aansluitovereenkomst_refused"));
        this.hidden = this.booleanValue(metaData.get("coin:ss:hidden"));
        this.wikiUrlEn = (String)metaData.get("coin:ss:wiki_url:en");
        this.wikiUrlNl = (String)metaData.get("coin:ss:wiki_url:nl");
        Object attributes = metaData.get("attributes");
        if (attributes != null) {
            if (attributes instanceof List) {
                Map<String, List> collect = ((List)attributes).stream().collect(Collectors.toMap(attr -> attr, attr -> Collections.singletonList("*")));
                this.arp = ARP.fromAttributes(collect);
            } else {
                this.arp = ARP.fromAttributes((Map)((Map)attributes));
            }
        } else {
            this.arp = ARP.noArp();
        }
        String typeOfService = (String)metaData.get("coin:ss:type_of_service:en");
        if (StringUtils.hasText((String)typeOfService)) {
            this.typeOfServicesEn = Arrays.asList(typeOfService.split(","));
        }
        if (StringUtils.hasText((String)(typeOfService = (String)metaData.get("coin:ss:type_of_service:nl")))) {
            this.typeOfServicesNl = Arrays.asList(typeOfService.split(","));
        }
        this.addUrl("en", (String)metaData.get("url:en"));
        this.addUrl("nl", (String)metaData.get("url:nl"));
        this.privacyInfo = this.buildPrivacyInfo(metaData);
        this.arpMotivations = (Map)metaData.get("motivations");
        this.manipulationNotes = (String)metaData.get("manipulationNotes");
        this.manipulation = StringUtils.hasText((String)((String)metaData.get("manipulation")));
    }

    private PrivacyInfo buildPrivacyInfo(Map<String, Object> metaData) {
        return new PrivacyInfo((String)metaData.get("coin:privacy:access_data"), this.booleanOptionalValue(metaData.get("coin:privacy:certification")), (String)metaData.get("coin:privacy:certification_location"), (String)metaData.get("coin:privacy:country"), (String)metaData.get("coin:privacy:other_info"), this.booleanOptionalValue(metaData.get("coin:privacy:privacy_policy")), (String)metaData.get("coin:privacy:privacy_policy_url"), (String)metaData.get("coin:privacy:security_measures"), (String)metaData.get("coin:privacy:sn_dpa_why_not"), this.booleanOptionalValue(metaData.get("coin:privacy:surfmarket_dpa_agreement")), this.booleanOptionalValue(metaData.get("coin:privacy:surfnet_dpa_agreement")), (String)metaData.get("coin:privacy:what_data"), this.booleanOptionalValue(metaData.get("coin:ss:aansluitovereenkomst_refused")), (String)metaData.get("coin:privacy:certification_valid_from"), (String)metaData.get("coin:privacy:certification_valid_to"), this.booleanOptionalValue(metaData.get("coin:privacy:gdpr_is_in_wiki")));
    }

    public boolean isIdpVisibleOnly() {
        return this.idpVisibleOnly;
    }

    public boolean isPolicyEnforcementDecisionRequired() {
        return this.policyEnforcementDecisionRequired;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getEulaURL() {
        return this.eulaURL;
    }

    public String getInterfedSource() {
        return this.interfedSource;
    }

    public String getPrivacyStatementUrlEn() {
        return this.privacyStatementUrlEn;
    }

    public String getPrivacyStatementUrlNl() {
        return this.privacyStatementUrlNl;
    }

    public String getRegistrationInfo() {
        return this.registrationInfo;
    }

    public String getRegistrationPolicyUrlEn() {
        return this.registrationPolicyUrlEn;
    }

    public String getRegistrationPolicyUrlNl() {
        return this.registrationPolicyUrlNl;
    }

    public Map<String, String> getUrls() {
        return this.urls;
    }

    public String getUrl(Provider.Language language) {
        return CollectionUtils.isEmpty((Map)this.urls) ? null : (String)this.urls.get(language.name());
    }

    public PrivacyInfo getPrivacyInfo() {
        return this.privacyInfo;
    }

    public Map<String, String> getArpMotivations() {
        return this.arpMotivations;
    }

    private void addUrl(String lang, String url) {
        if (StringUtils.hasText((String)url)) {
            this.urls.put(lang, url);
        }
    }

    public ARP getArp() {
        return this.arp;
    }

    public boolean isExampleSingleTenant() {
        return this.exampleSingleTenant;
    }

    public void setExampleSingleTenant(boolean exampleSingleTenant) {
        this.exampleSingleTenant = exampleSingleTenant;
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public String getEntityCategories1() {
        return this.entityCategories1;
    }

    public String getEntityCategories2() {
        return this.entityCategories2;
    }

    public String toString() {
        return "ServiceProvider{id='" + this.getId() + '\'' + ", applicationUrl='" + this.applicationUrl + '\'' + ", institutionId='" + this.institutionId + '\'' + ", eulaURL='" + this.eulaURL + '\'' + ", idpVisibleOnly=" + this.idpVisibleOnly + ", policyEnforcementDecisionRequired=" + this.policyEnforcementDecisionRequired + ", exampleSingleTenant=" + this.exampleSingleTenant + ", arp=" + this.arp + ", urls=" + this.urls + '}';
    }

    public ServiceProvider clone() {
        try {
            return (ServiceProvider)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public LicenseStatus getLicenseStatus() {
        return this.licenseStatus;
    }

    public boolean isStrongAuthenticationSupported() {
        return this.strongAuthenticationSupported;
    }

    public String getWikiUrlNl() {
        return this.wikiUrlNl;
    }

    public String getWikiUrlEn() {
        return this.wikiUrlEn;
    }

    public List<String> getTypeOfServicesNl() {
        return this.typeOfServicesNl;
    }

    public List<String> getTypeOfServicesEn() {
        return this.typeOfServicesEn;
    }

    public boolean isAansluitovereenkomstRefused() {
        return this.aansluitovereenkomstRefused;
    }

    public String getManipulationNotes() {
        return this.manipulationNotes;
    }

    public boolean isManipulation() {
        return this.manipulation;
    }
}

