/*
 * Decompiled with CFR 0.152.
 */
package selfservice.service.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import selfservice.domain.Action;
import selfservice.domain.Change;
import selfservice.domain.Provider;
import selfservice.manage.EntityType;
import selfservice.manage.Manage;
import selfservice.service.ActionsService;
import selfservice.service.EmailService;
import selfservice.service.impl.JiraClient;

@Service
public class ActionsServiceImpl
implements ActionsService {
    private static final Pattern namePattern = Pattern.compile("^Applicant name: (.*)$", 8);
    private static final Pattern emailPattern = Pattern.compile("^Applicant email: (.*)$", 8);
    @Autowired
    private JiraClient jiraClient;
    @Autowired
    private EmailService emailService;
    @Autowired
    private Manage manage;
    @Value(value="${administration.email.enabled}")
    private boolean sendAdministrationEmail;

    public Map<String, Object> getActions(String identityProvider, int startAt, int maxResults) {
        Map result = this.jiraClient.getTasks(identityProvider, startAt, maxResults);
        List issues = (List)result.get("issues");
        List enrichedActions = issues.stream().map(arg_0 -> this.addNames(arg_0)).map(arg_0 -> this.addUser(arg_0)).collect(Collectors.toList());
        HashMap<String, Object> copyResult = new HashMap<String, Object>(result);
        copyResult.put("issues", enrichedActions);
        return copyResult;
    }

    private Action addUser(Action action) {
        String body = action.getBody();
        Optional userEmail = this.findUserEmail(body);
        Optional userName = this.findUserName(body);
        return action.unbuild().userEmail(userEmail.orElse("unknown")).userName(userName.orElse("unknown")).build();
    }

    private Optional<String> findUserEmail(String body) {
        return this.matchingGroup(emailPattern, body);
    }

    private Optional<String> findUserName(String body) {
        return this.matchingGroup(namePattern, body);
    }

    private Optional<String> matchingGroup(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return Optional.ofNullable(matcher.group(1));
        }
        return Optional.empty();
    }

    public Action create(Action action, List<Change> changes) {
        String jiraKey = this.jiraClient.create(action, changes);
        Action savedAction = this.addNames(action).unbuild().jiraKey(jiraKey).build();
        this.sendAdministrationEmail(savedAction);
        return savedAction;
    }

    private Action addNames(Action action) {
        Optional serviceProvider = this.manage.getServiceProvider(action.getSpId(), EntityType.saml20_sp, true);
        Optional identityProvider = this.manage.getIdentityProvider(action.getIdpId(), true);
        return action.unbuild().idpName(identityProvider.map(Provider::getName).orElse("Information unavailable")).spName(serviceProvider.map(Provider::getName).orElse("Information unavailable")).build();
    }

    private void sendAdministrationEmail(Action action) {
        if (!this.sendAdministrationEmail) {
            return;
        }
        String subject = String.format("[Services (%s) request] %s connection from IdP '%s' to SP '%s' (Issue : %s)", this.getHost(), action.getType().name(), action.getIdpId(), action.getSpId(), action.getJiraKey().orElse("???"));
        StringBuilder body = new StringBuilder();
        body.append("SP EntityID: " + action.getSpId() + "\n");
        body.append("SP Name: " + action.getSpName() + "\n");
        body.append("IdP EntityID: " + action.getIdpId() + "\n");
        body.append("IdP Name: " + action.getIdpName() + "\n");
        body.append("Request: " + action.getType().name() + "\n");
        body.append("Applicant name: " + action.getUserName() + "\n");
        body.append("Applicant email: " + action.getUserEmail() + " \n");
        body.append("Mail applicant: mailto:" + action.getUserEmail() + "?CC=surfconext-beheer@surfnet.nl&SUBJECT=[" + action.getJiraKey().orElse("???") + "]%20" + action.getType().name() + "%20to%20" + action.getSpName() + "&BODY=Beste%20" + action.getUserName() + " \n");
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:MM");
        body.append("Time: " + sdf.format(new Date()) + "\n");
        body.append("Remark from User:\n");
        body.append(action.getBody());
        this.emailService.sendMail(action.getUserEmail(), subject.toString(), body.toString());
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }
}

