/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nl.surfnet.spring.security.opensaml.util.KeyStoreUtil;
import org.apache.commons.ssl.Base64;
import org.springframework.beans.factory.annotation.Required;

public class KeyStore {
    private String keystorePassword = "secret";
    private java.security.KeyStore keyStore;
    private Map<String, String> passwords = new HashMap<String, String>();

    public KeyStore() {
        try {
            this.keyStore = java.security.KeyStore.getInstance("JKS");
            this.keyStore.load(null, this.keystorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Required
    public void setCertificates(Map<String, String> certificates) {
        for (Map.Entry<String, String> entry : certificates.entrySet()) {
            this.addCertificate(entry.getKey(), entry.getValue());
        }
    }

    public java.security.KeyStore getJavaSecurityKeyStore() {
        return this.keyStore;
    }

    public void addPrivateKey(String alias, String privateKey, String certificate, String password) {
        String wrappedCert = "-----BEGIN CERTIFICATE-----\n" + certificate + "\n-----END CERTIFICATE-----";
        byte[] decodedKey = Base64.decodeBase64((byte[])privateKey.getBytes());
        try {
            KeyStoreUtil.appendKeyToKeyStore(this.keyStore, alias, new ByteArrayInputStream(wrappedCert.getBytes()), new ByteArrayInputStream(decodedKey), password.toCharArray());
            this.passwords.put(alias, password);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addCertificate(String alias, String certificate) {
        KeyStoreUtil.appendCertificateToKeyStore(this.keyStore, alias, certificate);
    }

    public Map<String, String> getPrivateKeyPasswords() {
        return this.passwords;
    }
}

