/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class SignatureSecurityPolicyRule
implements InitializingBean,
SecurityPolicyRule {
    private static final Logger log = LoggerFactory.getLogger(SignatureSecurityPolicyRule.class);
    private CredentialResolver credentialResolver;
    private final SAMLSignatureProfileValidator samlSignatureProfileValidator;
    ExplicitKeySignatureTrustEngine trustEngine;

    public SignatureSecurityPolicyRule(SAMLSignatureProfileValidator samlSignatureProfileValidator) {
        this.samlSignatureProfileValidator = samlSignatureProfileValidator;
    }

    @Required
    public void setCredentialResolver(CredentialResolver credentialResolver) {
        this.credentialResolver = credentialResolver;
    }

    public void afterPropertiesSet() throws Exception {
        System.out.println("Aap " + Configuration.getGlobalSecurityConfiguration());
        KeyInfoCredentialResolver keyInfoCredResolver = Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver();
        this.trustEngine = new ExplicitKeySignatureTrustEngine(this.credentialResolver, keyInfoCredResolver);
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        log.debug("evaluating signature of {}", (Object)messageContext);
        if (!(messageContext.getInboundMessage() instanceof SignableSAMLObject)) {
            throw new SecurityPolicyException("Inbound Message is not a SignableSAMLObject");
        }
        Response response = (Response)messageContext.getInboundMessage();
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        if (!response.isSigned() && !assertion.isSigned()) {
            throw new SecurityPolicyException("The SAML response was not signed");
        }
        if (response.isSigned()) {
            this.checkSignatureProfile((SignableSAMLObject)response);
            this.checkMessageSignature(messageContext, (SignableSAMLObject)response);
        }
        if (assertion.isSigned()) {
            this.checkSignatureProfile((SignableSAMLObject)assertion);
            this.checkMessageSignature(messageContext, (SignableSAMLObject)assertion);
        }
    }

    private void checkSignatureProfile(SignableSAMLObject samlMessage) throws SecurityPolicyException {
        try {
            Signature signature = samlMessage.getSignature();
            if (signature != null) {
                this.samlSignatureProfileValidator.validate(signature);
            }
        }
        catch (ValidationException ve) {
            throw new SecurityPolicyException("Signature did not conform to SAML Signature profile", (Exception)((Object)ve));
        }
    }

    private void checkMessageSignature(MessageContext messageContext, SignableSAMLObject samlMessage) throws SecurityPolicyException {
        CriteriaSet criteriaSet = new CriteriaSet();
        log.debug("Inbound issuer is {}", (Object)messageContext.getInboundMessageIssuer());
        criteriaSet.add((Object)new EntityIDCriteria(messageContext.getInboundMessageIssuer()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        try {
            if (!this.trustEngine.validate(samlMessage.getSignature(), criteriaSet)) {
                throw new SecurityPolicyException("Signature was either invalid or signing key could not be established as trusted");
            }
        }
        catch (SecurityException e) {
            throw new SecurityPolicyException("Error evaluating the signature", (Exception)((Object)e));
        }
    }
}

