/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import java.util.Collection;
import org.opensaml.saml2.core.Response;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SAMLAuthenticationToken
extends AbstractAuthenticationToken {
    private final Object principal;
    private final Object credentials;

    public SAMLAuthenticationToken(Response response, String credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = response;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }

    public SAMLAuthenticationToken(UserDetails user, String credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = user;
        this.credentials = credentials;
        super.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        }
        super.setAuthenticated(false);
    }
}

