/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class KeyStoreUtil {
    public static void appendKeyToKeyStore(KeyStore keyStore, String keyAlias, InputStream certificateInputStream, InputStream privatekeyInputStream, char[] password) throws IOException {
        Certificate cert;
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            cert = certFact.generateCertificate(certificateInputStream);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not instantiate cert", e);
        }
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        certs.add(cert);
        byte[] privKeyBytes = IOUtils.toByteArray((InputStream)privatekeyInputStream);
        try {
            PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(privKeyBytes);
            RSAPrivateKey privKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(ks);
            keyStore.setKeyEntry(keyAlias, privKey, password, certs.toArray(new Certificate[certs.size()]));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendCertificateToKeyStore(KeyStore keyStore, String keyAlias, String pemCert) {
        String wrappedCert = "-----BEGIN CERTIFICATE-----\n" + pemCert + "\n-----END CERTIFICATE-----";
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(wrappedCert.getBytes());
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate cert = certificateFactory.generateCertificate(certificateInputStream);
            IOUtils.closeQuietly((InputStream)certificateInputStream);
            keyStore.setCertificateEntry(keyAlias, cert);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

