/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import java.util.Collection;
import nl.surfnet.spring.security.opensaml.AssertionConsumer;
import nl.surfnet.spring.security.opensaml.SAMLAuthenticationToken;
import org.opensaml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SAMLResponseAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(SAMLResponseAuthenticationProvider.class);
    private final AssertionConsumer assertionConsumer;

    public SAMLResponseAuthenticationProvider(AssertionConsumer assertionConsumer) {
        this.assertionConsumer = assertionConsumer;
    }

    public Authentication authenticate(Authentication submitted) throws AuthenticationException {
        logger.debug("attempting to authenticate: {}", (Object)submitted);
        UserDetails user = this.assertionConsumer.consume((Response)submitted.getPrincipal());
        SAMLAuthenticationToken authenticated = new SAMLAuthenticationToken(user, (String)submitted.getCredentials(), (Collection<? extends GrantedAuthority>)user.getAuthorities());
        authenticated.setDetails(submitted.getDetails());
        logger.debug("Returning with authentication token of {}", (Object)authenticated);
        return authenticated;
    }

    public boolean supports(Class<? extends Object> authentication) {
        return SAMLAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

