/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml.config;

import java.io.IOException;
import java.util.Properties;
import nl.surfnet.spring.security.opensaml.AssertionConsumerImpl;
import nl.surfnet.spring.security.opensaml.AuthenticationFailureHandlerImpl;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandlerImpl;
import nl.surfnet.spring.security.opensaml.SAMLResponseAuthenticationProcessingFilter;
import nl.surfnet.spring.security.opensaml.SAMLResponseAuthenticationProvider;
import nl.surfnet.spring.security.opensaml.SecurityPolicyDelegate;
import nl.surfnet.spring.security.opensaml.SignatureSecurityPolicyRule;
import nl.surfnet.spring.security.opensaml.crypt.KeyStoreCredentialResolverDelegate;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.common.binding.security.MessageReplayRule;
import org.opensaml.saml2.binding.decoding.HTTPPostSimpleSignDecoder;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.util.storage.MapBasedStorageService;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.ui.velocity.VelocityEngineFactoryBean;
import org.w3c.dom.Element;

public class ServiceProviderBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public static final String BEAN_REPLAYCACHE = "samlReplayCache";
    public static final String BEAN_KEYSTORECREDENTIALRESOLVER = "samlKeyStoreCredentialResolverDelegate";
    public static final String BEAN_SECURITYPOLICY = "samlSecurityPolicy";
    public static final String BEAN_SECURITYPOLICYRESOLVER = "samlSecurityPolicyResolver";
    public static final String BEAN_SAMLINITIALIZER = "samlInitializer";
    public static final String BEAN_ASSERTIONCONSUMER = "samlAssertionConsumer";
    public static final String BEAN_AUTHENTICATIONPROVIDER = "samlAuthenticationProvider";
    private int newClockSkew = 90;
    private int newExpires = 300;
    private long replayCacheDuration = 14400000L;
    private int poolSizeInt = 2;

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String assertionConsumerURI;
        String entityID;
        String authenticationManangerRef;
        String provisionerRef;
        String certificatestoreRef;
        String messageHandlerRef;
        String preAuthFilterRef = element.getAttribute("preauth-filter-ref");
        if (StringUtils.isBlank((String)preAuthFilterRef)) {
            parserContext.getReaderContext().error("The preauth-filter-ref is mandatory", (Object)element);
        }
        if (StringUtils.isBlank((String)(messageHandlerRef = element.getAttribute("message-handler-ref")))) {
            parserContext.getReaderContext().error("The message-handler-ref is mandatory", (Object)element);
        }
        if (StringUtils.isBlank((String)(certificatestoreRef = element.getAttribute("certificatestore-ref")))) {
            parserContext.getReaderContext().error("The certificatestore-ref is mandatory", (Object)element);
        }
        if (StringUtils.isBlank((String)(provisionerRef = element.getAttribute("provisioner-ref")))) {
            parserContext.getReaderContext().error("The provisioner-ref is mandatory", (Object)element);
        }
        if (StringUtils.isBlank((String)(authenticationManangerRef = element.getAttribute("authentication-manager-ref")))) {
            parserContext.getReaderContext().error("The authentication-manager-ref is mandatory", (Object)element);
        }
        if (StringUtils.isBlank((String)(entityID = element.getAttribute("entity-id")))) {
            parserContext.getReaderContext().error("The entity-id is mandatory", (Object)element);
        }
        if (StringUtils.isBlank((String)(assertionConsumerURI = element.getAttribute("assertion-consumer-uri")))) {
            parserContext.getReaderContext().error("Missing or empty assertion-consumer-uri.", (Object)element);
        }
        String poolSize = element.getAttribute("max-parser-pool-size");
        try {
            this.poolSizeInt = Integer.parseInt(poolSize);
        }
        catch (NumberFormatException nfe) {
            parserContext.getReaderContext().error("An invalid value for max-parser-pool-size was supplied", (Object)element);
        }
        String replayCacheLife = element.getAttribute("replay-cache-life-in-millis");
        try {
            this.replayCacheDuration = Integer.parseInt(replayCacheLife);
        }
        catch (NumberFormatException nfe) {
            parserContext.getReaderContext().error("An invalid value for replay-cache-life-in-millis was supplied", (Object)element);
        }
        String clockSkew = element.getAttribute("issue-instant-check-clock-skew-in-secs");
        try {
            this.newClockSkew = Integer.parseInt(clockSkew);
        }
        catch (NumberFormatException nfe) {
            parserContext.getReaderContext().error("An invalid value for issue-instant-check-clock-skew-in-secs was supplied", (Object)element);
        }
        String validTime = element.getAttribute("issue-instant-check-valid-time-in-secs");
        try {
            this.newExpires = Integer.parseInt(validTime);
        }
        catch (NumberFormatException nfe) {
            parserContext.getReaderContext().error("An invalid value for issue-instant-check-valid-time-in-secs was supplied", (Object)element);
        }
        BeanDefinitionBuilder bootstrapBean = BeanDefinitionBuilder.genericBeanDefinition(DefaultBootstrap.class);
        bootstrapBean.setInitMethodName("bootstrap");
        parserContext.getRegistry().registerBeanDefinition(BEAN_SAMLINITIALIZER, (BeanDefinition)bootstrapBean.getBeanDefinition());
        BasicParserPool basicParserPool = new BasicParserPool();
        basicParserPool.setMaxPoolSize(this.poolSizeInt);
        HTTPPostSimpleSignDecoder httpPostSimpleSignDecoder = new HTTPPostSimpleSignDecoder((ParserPool)basicParserPool);
        VelocityEngineFactoryBean velocityEngineFactoryBean = new VelocityEngineFactoryBean();
        velocityEngineFactoryBean.setPreferFileSystemAccess(false);
        Properties velocityEngineProperties = new Properties();
        velocityEngineProperties.setProperty("resource.loader", "classpath");
        velocityEngineProperties.setProperty("classpath.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        velocityEngineFactoryBean.setVelocityProperties(velocityEngineProperties);
        VelocityEngine velocityEngine = null;
        try {
            velocityEngine = velocityEngineFactoryBean.createVelocityEngine();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create velocity engine instance");
        }
        BeanDefinitionBuilder replayCacheBuilder = BeanDefinitionBuilder.genericBeanDefinition(ReplayCache.class);
        replayCacheBuilder.addConstructorArgValue((Object)new MapBasedStorageService());
        replayCacheBuilder.addConstructorArgValue((Object)this.replayCacheDuration);
        parserContext.getRegistry().registerBeanDefinition(BEAN_REPLAYCACHE, (BeanDefinition)replayCacheBuilder.getBeanDefinition());
        BeanDefinitionBuilder messageReplayRuleBuilder = BeanDefinitionBuilder.genericBeanDefinition(MessageReplayRule.class);
        messageReplayRuleBuilder.addConstructorArgReference(BEAN_REPLAYCACHE);
        parserContext.getRegistry().registerBeanDefinition("messageReplayRule", (BeanDefinition)messageReplayRuleBuilder.getBeanDefinition());
        BeanDefinitionBuilder issueInstantBuilder = BeanDefinitionBuilder.genericBeanDefinition(IssueInstantRule.class);
        issueInstantBuilder.addConstructorArgValue((Object)this.newClockSkew);
        issueInstantBuilder.addConstructorArgValue((Object)this.newExpires);
        parserContext.getRegistry().registerBeanDefinition("issueInstantRule", (BeanDefinition)issueInstantBuilder.getBeanDefinition());
        BeanDefinitionBuilder keyStoreBuilder = BeanDefinitionBuilder.genericBeanDefinition(KeyStoreCredentialResolverDelegate.class);
        keyStoreBuilder.addPropertyReference("certificateStore", certificatestoreRef);
        parserContext.getRegistry().registerBeanDefinition(BEAN_KEYSTORECREDENTIALRESOLVER, (BeanDefinition)keyStoreBuilder.getBeanDefinition());
        BeanDefinitionBuilder signatureRuleBuilder = BeanDefinitionBuilder.genericBeanDefinition(SignatureSecurityPolicyRule.class);
        signatureRuleBuilder.addConstructorArgValue((Object)new SAMLSignatureProfileValidator());
        signatureRuleBuilder.addPropertyReference("credentialResolver", BEAN_KEYSTORECREDENTIALRESOLVER);
        ManagedList beanMetadataElements = new ManagedList();
        beanMetadataElements.add((Object)signatureRuleBuilder.getBeanDefinition());
        beanMetadataElements.add((Object)issueInstantBuilder.getBeanDefinition());
        beanMetadataElements.add((Object)messageReplayRuleBuilder.getBeanDefinition());
        BeanDefinitionBuilder securityPolicyDelegateBuilder = BeanDefinitionBuilder.genericBeanDefinition(SecurityPolicyDelegate.class);
        securityPolicyDelegateBuilder.addConstructorArgValue((Object)beanMetadataElements);
        parserContext.getRegistry().registerBeanDefinition(BEAN_SECURITYPOLICY, (BeanDefinition)securityPolicyDelegateBuilder.getBeanDefinition());
        BeanDefinitionBuilder securityPolicyResolverBuilder = BeanDefinitionBuilder.genericBeanDefinition(StaticSecurityPolicyResolver.class);
        securityPolicyResolverBuilder.addConstructorArgReference(BEAN_SECURITYPOLICY);
        parserContext.getRegistry().registerBeanDefinition(BEAN_SECURITYPOLICYRESOLVER, (BeanDefinition)securityPolicyResolverBuilder.getBeanDefinition());
        BeanDefinitionBuilder postBindingAdapter = BeanDefinitionBuilder.rootBeanDefinition(SAMLMessageHandlerImpl.class);
        postBindingAdapter.addConstructorArgValue((Object)httpPostSimpleSignDecoder);
        postBindingAdapter.addConstructorArgReference(BEAN_SECURITYPOLICYRESOLVER);
        postBindingAdapter.addPropertyValue("velocityEngine", (Object)velocityEngine);
        postBindingAdapter.addPropertyValue("entityId", (Object)entityID);
        parserContext.getRegistry().registerBeanDefinition(messageHandlerRef, (BeanDefinition)postBindingAdapter.getBeanDefinition());
        BeanDefinitionBuilder assertionComsumerBean = BeanDefinitionBuilder.genericBeanDefinition(AssertionConsumerImpl.class);
        assertionComsumerBean.addPropertyReference("provisioner", provisionerRef);
        parserContext.getRegistry().registerBeanDefinition(BEAN_ASSERTIONCONSUMER, (BeanDefinition)assertionComsumerBean.getBeanDefinition());
        BeanDefinitionBuilder authenticationProvider = BeanDefinitionBuilder.rootBeanDefinition(SAMLResponseAuthenticationProvider.class);
        authenticationProvider.addConstructorArgReference(BEAN_ASSERTIONCONSUMER);
        parserContext.getRegistry().registerBeanDefinition(BEAN_AUTHENTICATIONPROVIDER, (BeanDefinition)authenticationProvider.getBeanDefinition());
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        AuthenticationFailureHandlerImpl authenticationFailureHandler = new AuthenticationFailureHandlerImpl((RequestCache)requestCache);
        BeanDefinitionBuilder authenticationFilter = BeanDefinitionBuilder.rootBeanDefinition(SAMLResponseAuthenticationProcessingFilter.class);
        authenticationFilter.addConstructorArgValue((Object)assertionConsumerURI);
        authenticationFilter.addPropertyReference("SAMLMessageHandler", messageHandlerRef);
        authenticationFilter.addPropertyReference("authenticationManager", authenticationManangerRef);
        authenticationFilter.addPropertyValue("authenticationFailureHandler", (Object)authenticationFailureHandler);
        parserContext.getRegistry().registerBeanDefinition(preAuthFilterRef, (BeanDefinition)authenticationFilter.getBeanDefinition());
        return authenticationProvider.getBeanDefinition();
    }
}

