/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml.controller;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.spring.security.opensaml.AuthnRequestGenerator;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import nl.surfnet.spring.security.opensaml.util.IDService;
import nl.surfnet.spring.security.opensaml.util.TimeService;
import nl.surfnet.spring.security.opensaml.xml.EndpointGenerator;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuthnRequestController {
    private static final Logger log = LoggerFactory.getLogger(AuthnRequestController.class);
    private final TimeService timeService = new TimeService();
    private final IDService idService = new IDService();
    private SAMLMessageHandler samlMessageHandler;
    private String assertionConsumerServiceURL;
    private String entityID;

    @Required
    public void setSAMLMessageHandler(SAMLMessageHandler samlMessageHandler) {
        this.samlMessageHandler = samlMessageHandler;
    }

    @Required
    public void setAssertionConsumerServiceURL(String assertionConsumerServiceURL) {
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
    }

    @Required
    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    @RequestMapping(value={"/OpenSAML.sso/Login"}, method={RequestMethod.GET})
    public void commence(@RequestParam(value="target") String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthnRequestGenerator authnRequestGenerator = new AuthnRequestGenerator(this.entityID, this.timeService, this.idService);
        EndpointGenerator endpointGenerator = new EndpointGenerator();
        Endpoint endpoint = endpointGenerator.generateEndpoint(SingleSignOnService.DEFAULT_ELEMENT_NAME, target, this.assertionConsumerServiceURL);
        AuthnRequest authnReqeust = authnRequestGenerator.generateAuthnRequest(target, this.assertionConsumerServiceURL);
        log.debug("Sending authnRequest to {}", (Object)target);
        try {
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new EntityIDCriteria(this.entityID));
            criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
            this.samlMessageHandler.sendSAMLMessage((SignableSAMLObject)authnReqeust, endpoint, response);
        }
        catch (MessageEncodingException mee) {
            log.error("Could not send authnRequest to Identity Provider.", (Throwable)mee);
            response.sendError(500);
        }
    }
}

