/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Map;
import nl.surfnet.spring.security.opensaml.CertificateStore;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class CertificateStoreImpl
implements CertificateStore,
InitializingBean {
    private String keystorePassword;
    private KeyStore keyStore;
    private Map<String, String> certificates;

    @Required
    public void setCertificates(Map<String, String> certificates) {
        this.certificates = certificates;
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void afterPropertiesSet() throws Exception {
        this.keystorePassword = "secret";
        try {
            this.keyStore = KeyStore.getInstance("JKS");
            this.keyStore.load(null, this.keystorePassword.toCharArray());
            for (Map.Entry<String, String> entry : this.certificates.entrySet()) {
                this.appendToKeyStore(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void appendToKeyStore(String keyAlias, String pemCert) throws Exception {
        String wrappedCert = "-----BEGIN CERTIFICATE-----\n" + pemCert + "\n-----END CERTIFICATE-----";
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(wrappedCert.getBytes());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate cert = certificateFactory.generateCertificate(certificateInputStream);
        IOUtils.closeQuietly((InputStream)certificateInputStream);
        this.keyStore.setCertificateEntry(keyAlias, cert);
    }
}

