/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.spring.security.opensaml.SAMLAuthenticationToken;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import nl.surfnet.spring.security.opensaml.ServiceProviderAuthenticationException;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Response;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class SAMLResponseAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger logger = LoggerFactory.getLogger(SAMLResponseAuthenticationProcessingFilter.class);
    private SAMLMessageHandler samlMessageHandler;

    @Required
    public void setSAMLMessageHandler(SAMLMessageHandler samlMessageHandler) {
        this.samlMessageHandler = samlMessageHandler;
    }

    public SAMLResponseAuthenticationProcessingFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        logger.debug("Attempting authentication.");
        SAMLMessageContext messageContext = null;
        try {
            messageContext = this.samlMessageHandler.extractSAMLMessageContext(request);
        }
        catch (MessageDecodingException me) {
            throw new ServiceProviderAuthenticationException("Could not decode SAML Response", me);
        }
        catch (SecurityException se) {
            throw new ServiceProviderAuthenticationException("Could not decode SAML Response", se);
        }
        logger.debug("Message received from issuer: " + messageContext.getInboundMessageIssuer());
        if (!(messageContext.getInboundSAMLMessage() instanceof Response)) {
            throw new ServiceProviderAuthenticationException("SAML Message was not a Response.");
        }
        String credentials = this.samlMessageHandler.extractSAMLMessage(request);
        SAMLAuthenticationToken authRequest = new SAMLAuthenticationToken((Response)messageContext.getInboundSAMLMessage(), credentials, null);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        logger.debug("authRequest.getDetails(): {}", authRequest.getDetails());
        Authentication authenticate = this.getAuthenticationManager().authenticate((Authentication)authRequest);
        return authenticate;
    }
}

