/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml.crypt;

import java.util.Collections;
import java.util.Map;
import nl.surfnet.spring.security.opensaml.CertificateStore;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.springframework.beans.factory.annotation.Required;

public class KeyStoreCredentialResolverDelegate
implements CredentialResolver {
    private CertificateStore certificateStore;

    @Required
    public void setCertificateStore(CertificateStore certificateStore) {
        this.certificateStore = certificateStore;
    }

    public Iterable<Credential> resolve(CriteriaSet criteriaSet) throws SecurityException {
        return this.getKeyStoreCredentialResolver().resolve(criteriaSet);
    }

    public Credential resolveSingle(CriteriaSet criteriaSet) throws SecurityException {
        return this.getKeyStoreCredentialResolver().resolveSingle(criteriaSet);
    }

    public KeyStoreCredentialResolver getKeyStoreCredentialResolver() {
        Map privateKeyPasswords = Collections.emptyMap();
        return new KeyStoreCredentialResolver(this.certificateStore.getKeyStore(), privateKeyPasswords);
    }
}

