/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.spring.security.opensaml.IdentityProviderAuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class AuthenticationFailureHandlerImpl
implements AuthenticationFailureHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationFailureHandlerImpl.class);
    private final RequestCache requestCache;

    public AuthenticationFailureHandlerImpl(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        logger.debug("saved Request: {}", (Object)savedRequest);
        if (authenticationException instanceof IdentityProviderAuthenticationException && savedRequest != null) {
            logger.warn("Authn Failure reported by the IDP.", (Throwable)authenticationException);
            logger.debug("Retry original request of {}", (Object)savedRequest.getRedirectUrl());
            response.sendRedirect(savedRequest.getRedirectUrl());
        } else {
            logger.warn("Unrecoverable authn failure. Sending to Forbidden", (Throwable)authenticationException);
            response.sendError(403);
        }
    }
}

