/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.surfnet.spring.security.opensaml.AssertionConsumer;
import nl.surfnet.spring.security.opensaml.IdentityProviderAuthenticationException;
import nl.surfnet.spring.security.opensaml.Provisioner;
import nl.surfnet.spring.security.opensaml.ServiceProviderAuthenticationException;
import nl.surfnet.spring.security.opensaml.xml.SAML2ValidatorSuite;
import org.apache.commons.lang.StringUtils;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;

public class AssertionConsumerImpl
implements AssertionConsumer {
    private static final Logger log = LoggerFactory.getLogger(AssertionConsumerImpl.class);
    private Provisioner provisioner;
    SAML2ValidatorSuite validatorSuite = new SAML2ValidatorSuite();

    @Required
    public void setProvisioner(Provisioner provisioner) {
        this.provisioner = provisioner;
    }

    @Override
    public UserDetails consume(Response samlResponse) throws AuthenticationException {
        try {
            this.validatorSuite.validate((XMLObject)samlResponse);
        }
        catch (ValidationException ve) {
            log.warn("Response Message failed Validation", (Throwable)ve);
            throw new ServiceProviderAuthenticationException("Invalid SAML REsponse Message", ve);
        }
        this.checkResponseStatus(samlResponse);
        Assertion assertion = (Assertion)samlResponse.getAssertions().get(0);
        log.debug("authenticationResponseIssuingEntityName {}", (Object)samlResponse.getIssuer().getValue());
        log.debug("assertion.getID() {}", (Object)assertion.getID());
        log.debug("assertion.getSubject().getNameID().getValue() {}", (Object)assertion.getSubject().getNameID().getValue());
        AuthnStatement authnStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        log.debug("authnStatement.getAuthnInstant() {}", (Object)authnStatement.getAuthnInstant());
        Set<GrantedAuthority> authorities = this.extractAuthorities(assertion.getAttributeStatements());
        log.debug("Granted Authorities will be {}", authorities);
        log.debug("assertion.getID() {}", (Object)assertion.getAuthnStatements());
        return this.provisioner.provisionUser(assertion);
    }

    private Set<GrantedAuthority> extractAuthorities(List<AttributeStatement> attributeStatements) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        for (AttributeStatement attributeStatement : attributeStatements) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                if (!GrantedAuthority.class.getName().equalsIgnoreCase(attribute.getName())) continue;
                log.debug("found Granted Authorities.");
                for (XMLObject xmlObj : attribute.getAttributeValues()) {
                    if (!(xmlObj instanceof XSString)) continue;
                    authorities.add((GrantedAuthority)new GrantedAuthorityImpl(((XSString)xmlObj).getValue()));
                }
                return authorities;
            }
        }
        authorities.add((GrantedAuthority)new GrantedAuthorityImpl("ROLE_USER"));
        return authorities;
    }

    private void checkResponseStatus(Response samlResponse) {
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(StringUtils.trim((String)samlResponse.getStatus().getStatusCode().getValue()))) {
            StringBuilder extraInformation = this.extractExtraInformation(samlResponse);
            if (extraInformation.length() > 0) {
                log.warn("Extra information extracted from authentication failure was {}", (Object)extraInformation.toString());
                throw new IdentityProviderAuthenticationException("Identity Provider has failed the authentication.", extraInformation.toString());
            }
            throw new IdentityProviderAuthenticationException("Identity Provider has failed the authentication.");
        }
        this.additionalValidationChecksOnSuccessfulResponse(samlResponse);
    }

    private void additionalValidationChecksOnSuccessfulResponse(Response samlResponse) {
        if (samlResponse.getAssertions().isEmpty()) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain any assertions");
        }
        if (((Assertion)samlResponse.getAssertions().get(0)).getAuthnStatements().isEmpty()) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain an assertions with an AuthnStatement");
        }
        if (((Assertion)samlResponse.getAssertions().get(0)).getAttributeStatements().isEmpty()) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain an assertions with an AttributeStatements");
        }
        if (samlResponse.getIssuer() == null) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain any Issuer");
        }
    }

    private StringBuilder extractExtraInformation(Response samlResponse) {
        StringBuilder extraInformation = new StringBuilder();
        if (samlResponse.getStatus().getStatusCode().getStatusCode() != null) {
            extraInformation.append(samlResponse.getStatus().getStatusCode().getStatusCode().getValue());
        }
        if (samlResponse.getStatus().getStatusMessage() != null) {
            if (extraInformation.length() > 0) {
                extraInformation.append("  -  ");
            }
            extraInformation.append(samlResponse.getStatus().getStatusMessage());
        }
        return extraInformation;
    }
}

