/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.spring.security.opensaml;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml2.binding.encoding.HTTPPostSimpleSignEncoder;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.springframework.beans.factory.annotation.Required;

public class SAMLMessageHandlerImpl
implements SAMLMessageHandler {
    private static final String SAML_REQUEST_POST_PARAM_NAME = "SAMLRequest";
    private static final String SAML_RESPONSE_POST_PARAM_NAME = "SAMLResponse";
    private static String UNSIGNED_TEMPLATE = "/templates/saml2-post-simplesign-binding.vm";
    private static String SIGNED_TEMPLATE = "/templates/saml2-post-simplesign-binding.vm";
    private VelocityEngine velocityEngine;
    private final SAMLMessageDecoder decoder;
    private final SecurityPolicyResolver resolver;
    private String entityId;
    private boolean needsSigning;

    public SAMLMessageHandlerImpl(SAMLMessageDecoder decoder, SecurityPolicyResolver resolver) {
        this.decoder = decoder;
        this.resolver = resolver;
    }

    @Required
    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    public SAMLMessageContext extractSAMLMessageContext(HttpServletRequest request) throws MessageDecodingException, SecurityException {
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(request));
        messageContext.setSecurityPolicyResolver(this.resolver);
        this.decoder.decode((MessageContext)messageContext);
        return messageContext;
    }

    @Override
    public void sendSAMLMessage(SignableSAMLObject samlMessage, Endpoint endpoint, HttpServletResponse response, String relayState, Credential signingCredential) throws MessageEncodingException {
        HttpServletResponseAdapter outTransport = new HttpServletResponseAdapter(response, false);
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setOutboundMessageTransport((OutTransport)outTransport);
        messageContext.setPeerEntityEndpoint(endpoint);
        messageContext.setOutboundSAMLMessage((SAMLObject)samlMessage);
        if (this.isNeedsSigning()) {
            messageContext.setOutboundSAMLMessageSigningCredential(signingCredential);
        }
        messageContext.setOutboundMessageIssuer(this.getEntityId());
        messageContext.setRelayState(relayState);
        HTTPPostSimpleSignEncoder encoder = this.isNeedsSigning() ? new HTTPPostSimpleSignEncoder(this.velocityEngine, SIGNED_TEMPLATE, true) : new HTTPPostSimpleSignEncoder(this.velocityEngine, UNSIGNED_TEMPLATE, true);
        encoder.encode((MessageContext)messageContext);
    }

    @Override
    public String extractSAMLMessage(HttpServletRequest request) {
        if (StringUtils.isNotBlank((String)request.getParameter(SAML_REQUEST_POST_PARAM_NAME))) {
            return request.getParameter(SAML_REQUEST_POST_PARAM_NAME);
        }
        return request.getParameter(SAML_RESPONSE_POST_PARAM_NAME);
    }

    public void setNeedsSigning(boolean needsSigning) {
        this.needsSigning = needsSigning;
    }

    public boolean isNeedsSigning() {
        return this.needsSigning;
    }

    public String getEntityId() {
        return this.entityId;
    }
}

