/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.stoker;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import nl.surfnet.coin.stoker.StokerData;
import nl.surfnet.coin.stoker.StokerEntry;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.core.io.Resource;

public class Stoker {
    private final ObjectMapper objectMapper;
    private final Resource resource;
    private final StokerData stokerData;
    private static final Predicate<StokerEntry> onlyServiceProviders = new Predicate<StokerEntry>(){

        public boolean apply(StokerEntry input) {
            return input.isServiceProvider();
        }
    };

    public Stoker(Resource resource) throws IOException {
        this.resource = resource;
        this.objectMapper = new ObjectMapper();
        this.stokerData = (StokerData)this.objectMapper.readValue(IOUtils.toString((InputStream)resource.getInputStream()), StokerData.class);
    }

    public Collection<StokerEntry> getEduGainServiceProviders() {
        return Collections2.filter(this.stokerData.getEntities(), onlyServiceProviders);
    }

    public Collection<StokerEntry> getEduGainServiceProviders(final Collection<String> spEntityIds) {
        return Collections2.filter(this.getEduGainServiceProviders(), (Predicate)new Predicate<StokerEntry>(){

            public boolean apply(StokerEntry input) {
                return spEntityIds.contains(input.getEntityId());
            }
        });
    }
}

