/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.stoker;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.surfnet.coin.stoker.ContactPerson;
import nl.surfnet.coin.stoker.StokerData;
import nl.surfnet.coin.stoker.StokerEntry;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Stoker {
    public static final String NAMESPACE_URI = "urn:oasis:names:tc:SAML:2.0:metadata";
    private final ObjectMapper objectMapper;
    private final Resource detailDataFolder;
    private final StokerData stokerData;
    private static final Predicate<StokerEntry> onlyServiceProviders = new Predicate<StokerEntry>(){

        public boolean apply(StokerEntry input) {
            return input.isServiceProvider();
        }
    };

    public Stoker(Resource metaDataFileLocation, Resource detailDataFolder) throws Exception {
        this.detailDataFolder = detailDataFolder;
        this.objectMapper = new ObjectMapper();
        this.stokerData = (StokerData)this.objectMapper.readValue(IOUtils.toString((InputStream)metaDataFileLocation.getInputStream()), StokerData.class);
        for (StokerEntry stokerEntry : this.getEduGainServiceProviders()) {
            String filename = this.calculateFilename(stokerEntry.getEntityId());
            Document document = this.parseDetailData(filename);
            this.addContactPersonsFromDocument(stokerEntry, document);
        }
    }

    public Collection<StokerEntry> getEduGainServiceProviders() {
        return Collections2.filter(this.stokerData.getEntities(), onlyServiceProviders);
    }

    public Collection<StokerEntry> getEduGainServiceProviders(final Collection<String> spEntityIds) {
        return Collections2.filter(this.getEduGainServiceProviders(), (Predicate)new Predicate<StokerEntry>(){

            public boolean apply(StokerEntry input) {
                return spEntityIds.contains(input.getEntityId());
            }
        });
    }

    public StokerEntry getEduGainServiceProvider(String spEntityId) {
        return this.getEduGainServiceProviders(Arrays.asList(spEntityId)).iterator().next();
    }

    private void addContactPersonsFromDocument(StokerEntry stokerEntry, Document document) {
        NodeList contactPersons = document.getElementsByTagNameNS(NAMESPACE_URI, "ContactPerson");
        for (int i = 0; i < contactPersons.getLength(); ++i) {
            NodeList surNameNodes;
            if (contactPersons.item(i).getNodeType() != 1) continue;
            Element contactPersonNode = (Element)contactPersons.item(i);
            String contactType = contactPersonNode.getAttributes().getNamedItem("contactType").getTextContent();
            NodeList emailAddressNodes = contactPersonNode.getElementsByTagNameNS(NAMESPACE_URI, "EmailAddress");
            if (!this.any(emailAddressNodes)) continue;
            String emailAddress = emailAddressNodes.item(0).getTextContent().replaceAll("mailto:", "");
            NodeList givenNameNodes = contactPersonNode.getElementsByTagNameNS(NAMESPACE_URI, "GivenName");
            String fullName = "";
            if (this.any(givenNameNodes)) {
                fullName = givenNameNodes.item(0).getTextContent();
            }
            if (this.any(surNameNodes = contactPersonNode.getElementsByTagNameNS(NAMESPACE_URI, "SurName"))) {
                fullName = String.format("%s %s", fullName, surNameNodes.item(0).getTextContent()).trim();
            }
            stokerEntry.addContactPerson(new ContactPerson(contactType, fullName, emailAddress));
        }
    }

    private boolean any(NodeList nodes) {
        return nodes != null && nodes.getLength() > 0;
    }

    private Document parseDetailData(String filename) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(this.detailDataFolder.createRelative(filename + ".xml").getInputStream());
    }

    private String calculateFilename(String spEntityId) throws NoSuchAlgorithmException {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.reset();
        m.update(spEntityId.getBytes());
        byte[] digest = m.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String filename = bigInt.toString(16);
        while (filename.length() < 32) {
            filename = "0" + filename;
        }
        return filename;
    }
}

