/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.stoker;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.surfnet.coin.stoker.ContactPerson;
import nl.surfnet.coin.stoker.StokerData;
import nl.surfnet.coin.stoker.StokerEntry;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Stoker {
    public static final String ELEMENT_NAME_ID_FORMAT = "NameIDFormat";
    public static final String ELEMENT_ASSERTION_CONSUMER_SERVICE = "AssertionConsumerService";
    public static final String NAMESPACE_URI = "urn:oasis:names:tc:SAML:2.0:metadata";
    public static final String ATTR_BINDING = "Binding";
    public static final String ATTR_LOCATION = "Location";
    public static final String ATTR_INDEX = "index";
    private final ObjectMapper objectMapper;
    private final Resource detailDataFolder;
    private final StokerData stokerData;
    private static final Logger LOG = LoggerFactory.getLogger(Stoker.class);
    private static final Predicate<StokerEntry> onlyServiceProviders = new Predicate<StokerEntry>(){

        public boolean apply(StokerEntry input) {
            return input.isServiceProvider();
        }
    };

    public Stoker(Resource metaDataFileLocation, Resource detailDataFolder) throws Exception {
        this.detailDataFolder = detailDataFolder;
        this.objectMapper = new ObjectMapper();
        this.stokerData = (StokerData)this.objectMapper.readValue(IOUtils.toString((InputStream)metaDataFileLocation.getInputStream()), StokerData.class);
        for (StokerEntry stokerEntry : this.getEduGainServiceProviders()) {
            String filename = this.calculateFilename(stokerEntry.getEntityId());
            Document document = this.parseDetailData(filename);
            ElementTemplate elementTemplate = new ElementTemplate(document, stokerEntry);
            this.addContactPersonsFromDocument(elementTemplate);
            this.addAssertionConsumerServices(elementTemplate);
            this.addNameIdFormats(elementTemplate);
        }
    }

    private void addNameIdFormats(ElementTemplate elementTemplate) {
        elementTemplate.doForElements(ELEMENT_NAME_ID_FORMAT, new ElementHandler(){

            @Override
            public void handle(Element element, StokerEntry stokerEntry) {
                stokerEntry.addNameIdFormat(element.getTextContent());
            }
        });
    }

    private void addAssertionConsumerServices(ElementTemplate elementTemplate) {
        elementTemplate.doForElements(ELEMENT_ASSERTION_CONSUMER_SERVICE, new ElementHandler(){

            @Override
            public void handle(Element element, StokerEntry stokerEntry) {
                String binding = Stoker.this.getAttrValueFromElement(element, Stoker.ATTR_BINDING);
                String location = Stoker.this.getAttrValueFromElement(element, Stoker.ATTR_LOCATION);
                String index = Stoker.this.getAttrValueFromElement(element, Stoker.ATTR_INDEX);
                stokerEntry.addAssertionConsumerService((Map<String, String>)ImmutableMap.of((Object)Stoker.ATTR_BINDING, (Object)binding, (Object)Stoker.ATTR_LOCATION, (Object)location, (Object)Stoker.ATTR_INDEX, (Object)index));
            }
        });
    }

    public Collection<StokerEntry> getEduGainServiceProviders() {
        return Collections2.filter(this.stokerData.getEntities(), onlyServiceProviders);
    }

    public Collection<StokerEntry> getEduGainServiceProviders(final Collection<String> spEntityIds) {
        return Collections2.filter(this.getEduGainServiceProviders(), (Predicate)new Predicate<StokerEntry>(){

            public boolean apply(StokerEntry input) {
                return spEntityIds.contains(input.getEntityId());
            }
        });
    }

    public StokerEntry getEduGainServiceProvider(String spEntityId) {
        return this.getEduGainServiceProviders(Arrays.asList(spEntityId)).iterator().next();
    }

    private void addContactPersonsFromDocument(ElementTemplate elementTemplate) {
        elementTemplate.doForElements("ContactPerson", new ElementHandler(){

            @Override
            public void handle(Element element, StokerEntry stokerEntry) {
                String contactType = Stoker.this.getAttrValueFromElement(element, "contactType");
                String emailAddress = Stoker.this.getTextFromElement(element, "EmailAddress").replaceAll("mailto:", "");
                String givenName = Stoker.this.getTextFromElement(element, "GivenName");
                String surName = Stoker.this.getTextFromElement(element, "SurName");
                String company = Stoker.this.getTextFromElement(element, "Company");
                String phone = Stoker.this.getTextFromElement(element, "TelephoneNumber");
                stokerEntry.addContactPerson(new ContactPerson(contactType, givenName, surName, emailAddress, phone, company));
            }
        });
    }

    private String getTextFromElement(Element element, String nodeName) {
        String text = "";
        NodeList emailAddressNodes = element.getElementsByTagNameNS(NAMESPACE_URI, nodeName);
        if (this.any(emailAddressNodes)) {
            text = emailAddressNodes.item(0).getTextContent();
        }
        return text;
    }

    private String getAttrValueFromElement(Element element, String attribute) {
        Node node = element.getAttributes().getNamedItem(attribute);
        return node == null ? "" : node.getTextContent();
    }

    private NodeList getElementsFromDocument(Document document, String nodeName) {
        return document.getElementsByTagNameNS(NAMESPACE_URI, nodeName);
    }

    private boolean any(NodeList nodes) {
        return nodes != null && nodes.getLength() > 0;
    }

    private Document parseDetailData(String filename) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(this.detailDataFolder.createRelative(filename + ".xml").getInputStream());
    }

    private String calculateFilename(String spEntityId) throws NoSuchAlgorithmException {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.reset();
        m.update(spEntityId.getBytes());
        byte[] digest = m.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String filename = bigInt.toString(16);
        while (filename.length() < 32) {
            filename = "0" + filename;
        }
        LOG.debug("Calculated filename for entityId {} is {}.xml", (Object)spEntityId, (Object)filename);
        return filename;
    }

    private static class ElementTemplate {
        private final Document document;
        private final StokerEntry stokerEntry;

        public ElementTemplate(Document document, StokerEntry stokerEntry) {
            this.document = document;
            this.stokerEntry = stokerEntry;
        }

        public void doForElements(String elementName, ElementHandler elementHandler) {
            NodeList nodes = this.document.getElementsByTagNameNS(Stoker.NAMESPACE_URI, elementName);
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i).getNodeType() != 1) continue;
                Element element = (Element)nodes.item(i);
                elementHandler.handle(element, this.stokerEntry);
            }
        }
    }

    private static interface ElementHandler {
        public void handle(Element var1, StokerEntry var2);
    }
}

