/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.cruncher;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.surfnet.coin.oauth.OauthClient;
import org.springframework.util.StringUtils;
import org.surfnet.cruncher.Cruncher;
import org.surfnet.cruncher.model.SpStatistic;

public class CruncherClient
implements Cruncher {
    private OauthClient oauthClient;
    private String cruncherBaseLocation;

    public CruncherClient(String cruncherBaseLocation) {
        this.cruncherBaseLocation = cruncherBaseLocation;
    }

    @Override
    public String getLogins(Date startDate, Date endDate) {
        return this.doJsonGetFromCruncher("/logins?startDate={startDate}&endDate={endDate}", this.getLoginsVariables(startDate, endDate, null, null));
    }

    @Override
    public String getLoginsByIdpAndSp(Date startDate, Date endDate, String idpEntityId, String spEntityId) {
        return this.doJsonGetFromCruncher("/logins?startDate={startDate}&endDate={endDate}&idpEntityId={idpEntityId}&spEntityId={spEntityId}", this.getLoginsVariables(startDate, endDate, spEntityId, idpEntityId));
    }

    @Override
    public String getLoginsByIdp(Date startDate, Date endDate, String idpEntityId) {
        return this.doJsonGetFromCruncher("/logins?startDate={startDate}&endDate={endDate}&idpEntityId={idpEntityId}", this.getLoginsVariables(startDate, endDate, null, idpEntityId));
    }

    @Override
    public String getLoginsBySp(Date startDate, Date endDate, String spEntityId) {
        return this.doJsonGetFromCruncher("/logins?startDate={startDate}&endDate={endDate}&spEntityId={spEntityId}", this.getLoginsVariables(startDate, endDate, spEntityId, null));
    }

    @Override
    public List<SpStatistic> getRecentLoginsForUser(String userId, String idpEntityId) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("idpEntityId", idpEntityId);
        variables.put("userId", userId);
        return (List)this.oauthClient.exchange(this.cruncherBaseLocation + "/lastlogin?idpEntityId={idpEntityId}&userId={userId}", variables, SpStatistic[].class);
    }

    @Override
    public void setOauthClient(OauthClient oc) {
        this.oauthClient = oc;
    }

    private String doJsonGetFromCruncher(String subPath, Map<String, ?> variables) {
        return (String)this.oauthClient.exchange(this.cruncherBaseLocation + subPath, variables, String.class);
    }

    private Map<String, Object> getLoginsVariables(Date startDate, Date endDate, String spEntityId, String idpEntityId) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (StringUtils.hasText((String)idpEntityId)) {
            variables.put("idpEntityId", idpEntityId);
        }
        if (StringUtils.hasText((String)spEntityId)) {
            variables.put("spEntityId", spEntityId);
        }
        variables.put("startDate", startDate.getTime());
        variables.put("endDate", endDate.getTime());
        return variables;
    }

    public void setCruncherBaseLocation(String cruncherBaseLocation) {
        this.cruncherBaseLocation = cruncherBaseLocation;
    }
}

