/*
 * Decompiled with CFR 0.152.
 */
package broker;

import broker.domain.Institution;
import broker.exception.NotFoundException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class ServiceRegistry {
    private List<Institution> institutions;

    public ServiceRegistry(@Value(value="${service_registry.path}") Resource serviceRegistryResource) {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.institutions = (List)objectMapper.readValue(serviceRegistryResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Institution findInstitutionBySchacHome(String schacHome) {
        return this.institutions.stream().filter(institution -> institution.getSchacHome().equals(schacHome)).findAny().orElseThrow(NotFoundException::new);
    }
}

