/*
 * Decompiled with CFR 0.152.
 */
package broker.api;

import broker.ServiceRegistry;
import broker.domain.BrokerRequest;
import broker.domain.EnrollmentRequest;
import broker.domain.Institution;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class BrokerController {
    public static final String BROKER_REQUEST_SESSION_KEY = "BROKER_REQUEST_SESSION_KEY";
    private final String clientUrl;
    private final ServiceRegistry serviceRegistry;
    private final RestTemplate restTemplate = new RestTemplate();
    private Map<String, Boolean> featureToggles = new HashMap();
    private final ParameterizedTypeReference<Map<String, Object>> mapRef = new /* Unavailable Anonymous Inner Class!! */;

    public BrokerController(@Value(value="${config.broker_client_url}") String clientUrl, @Value(value="${config.local}") boolean local, @Value(value="${config.allow_playground}") boolean allowPlayground, ServiceRegistry serviceRegistry) {
        this.clientUrl = clientUrl;
        this.serviceRegistry = serviceRegistry;
        this.featureToggles.put("local", local);
        this.featureToggles.put("allowPlayground", allowPlayground);
    }

    @PostMapping(value={"/api/broker"}, consumes={"application/x-www-form-urlencoded"})
    public View brokerRequest(HttpServletRequest request, @ModelAttribute BrokerRequest brokerRequest) {
        brokerRequest.validate();
        request.getSession().setAttribute(BROKER_REQUEST_SESSION_KEY, (Object)brokerRequest);
        return new RedirectView(this.clientUrl + "?step=approve");
    }

    @GetMapping(value={"/api/features"})
    public Map<String, Boolean> features() {
        return this.featureToggles;
    }

    @GetMapping(value={"/api/offering"})
    public Map<String, Object> offering(HttpServletRequest request) {
        BrokerRequest brokerRequest = (BrokerRequest)request.getSession().getAttribute(BROKER_REQUEST_SESSION_KEY);
        Institution guestInstitution = this.serviceRegistry.findInstitutionBySchacHome(brokerRequest.getGuestInstitutionSchacHome());
        Institution homeInstitution = this.serviceRegistry.findInstitutionBySchacHome(brokerRequest.getHomeInstitutionSchacHome());
        String offeringURI = String.format("%s/%s", homeInstitution.getCourseEndpoint(), brokerRequest.getOfferingID());
        EnrollmentRequest enrollmentRequest = new EnrollmentRequest(offeringURI, homeInstitution.getPersonsEndpoint(), homeInstitution.getScopes());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("guestInstitution", guestInstitution.sanitize());
        result.put("homeInstitution", homeInstitution.sanitize());
        result.put("authenticationActionUrl", homeInstitution.getAuthenticationEndpoint());
        result.put("enrollmentRequest", enrollmentRequest);
        result.put("offering", this.fetchOffering(homeInstitution, brokerRequest));
        return result;
    }

    @PostMapping(value={"/api/start"})
    public Map<String, Object> start(HttpServletRequest request, @RequestBody Map<String, String> correlationMap) {
        if (((Boolean)this.featureToggles.get("allowPlayground")).booleanValue() && correlationMap.keySet().stream().anyMatch(s -> s.equals("code"))) {
            return new HashMap<String, Object>(correlationMap);
        }
        BrokerRequest brokerRequest = (BrokerRequest)request.getSession().getAttribute(BROKER_REQUEST_SESSION_KEY);
        Institution homeInstitution = this.serviceRegistry.findInstitutionBySchacHome(brokerRequest.getHomeInstitutionSchacHome());
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Correlation-ID", correlationMap.get("correlationID"));
        headers.setBasicAuth(homeInstitution.getRegistrationUser(), homeInstitution.getRegistrationPassword());
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        String url = homeInstitution.getRegistrationEndpoint().toString();
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, this.mapRef, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    private Map<String, Object> fetchOffering(Institution homeInstitution, BrokerRequest brokerRequest) {
        return (Map)this.restTemplate.getForEntity(String.format("%s/%s", homeInstitution.getCourseEndpoint(), brokerRequest.getOfferingID()), Map.class, new Object[0]).getBody();
    }
}

