/*
 * Decompiled with CFR 0.152.
 */
package broker;

import broker.ServiceRegistry;
import broker.domain.Institution;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class InMemoryServiceRegistry
implements ServiceRegistry {
    private final List<Institution> institutions;

    public InMemoryServiceRegistry(@Value(value="${service_registry.path}") Resource serviceRegistryResource) {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.institutions = (List)objectMapper.readValue(serviceRegistryResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.institutions.forEach(Institution::validate);
    }

    public Optional<Institution> findInstitutionBySchacHome(String schacHome) {
        return this.institutions.stream().filter(institution -> institution.getSchacHome().equals(schacHome)).findAny();
    }

    public List<Institution> allInstitutions() {
        return this.institutions;
    }
}

