/*
 * Decompiled with CFR 0.152.
 */
package broker.api;

import broker.LanguageFilter;
import broker.ServiceRegistry;
import broker.domain.BrokerRequest;
import broker.domain.CourseAuthentication;
import broker.domain.EnrollmentRequest;
import broker.domain.Institution;
import broker.exception.NotFoundException;
import broker.exception.RemoteException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class BrokerController {
    public static final String BROKER_REQUEST_SESSION_KEY = "BROKER_REQUEST_SESSION_KEY";
    public static final String OFFERING_SESSION_KEY = "OFFERING_SESSION_KEY";
    private static final Log LOG = LogFactory.getLog(BrokerController.class);
    private final String clientUrl;
    private final ServiceRegistry serviceRegistry;
    private final RestTemplate restTemplate = new RestTemplate();
    private final Map<String, Object> featureToggles = new HashMap();
    private final URI tokenEndpoint;
    private final String clientId;
    private final String secret;
    private final String sisUser;
    private final String sisPassword;
    private final String sisResultsEndpoint;
    private final ParameterizedTypeReference<Map<String, Object>> mapRef = new /* Unavailable Anonymous Inner Class!! */;

    public BrokerController(@Value(value="${config.broker_client_url}") String clientUrl, @Value(value="${config.start_broker_endpoint}") String startBrokerEndpoint, @Value(value="${config.oauth2.token_endpoint}") URI tokenEndpoint, @Value(value="${config.oauth2.client_id}") String clientId, @Value(value="${config.oauth2.secret}") String secret, @Value(value="${config.sis_user}") String sisUser, @Value(value="${config.sis_password}") String sisPassword, @Value(value="${config.sis_results_endpoint}") String sisResultsEndpoint, @Value(value="${config.local}") boolean local, @Value(value="${config.allow_playground}") boolean allowPlayground, @Value(value="${config.play_home_institution_schacHome}") String playHomeInstitutionSchacHome, @Value(value="${config.play_guest_institution_schacHome}") String playGuestInstitutionSchacHome, @Value(value="${config.play_offering_id}") String playOfferingID, @Value(value="${config.catalog_url}") String catalogUrl, ServiceRegistry serviceRegistry) {
        this.clientUrl = clientUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.secret = secret;
        this.sisUser = sisUser;
        this.sisPassword = sisPassword;
        this.sisResultsEndpoint = sisResultsEndpoint;
        this.serviceRegistry = serviceRegistry;
        this.featureToggles.put("startBrokerEndpoint", startBrokerEndpoint);
        this.featureToggles.put("local", local);
        this.featureToggles.put("allowPlayground", allowPlayground);
        this.featureToggles.put("catalogUrl", catalogUrl);
        if (allowPlayground) {
            this.featureToggles.put("playHomeInstitutionSchacHome", playHomeInstitutionSchacHome);
            this.featureToggles.put("playGuestInstitutionSchacHome", playGuestInstitutionSchacHome);
            this.featureToggles.put("offeringID", playOfferingID);
        }
        this.restTemplate.setInterceptors(Collections.singletonList((request, body, execution) -> {
            request.getHeaders().add("Accept-Language", (String)LanguageFilter.language.get());
            return execution.execute(request, body);
        }));
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        String[] denylist = new String[]{"class.*", "Class.*", "*.class.*", "*.Class.*"};
        dataBinder.setDisallowedFields(denylist);
    }

    @PostMapping(value={"/api/broker"}, consumes={"application/x-www-form-urlencoded"})
    public View brokerRequest(HttpServletRequest request, @ModelAttribute BrokerRequest brokerRequest, @RequestParam(value="play", required=false, defaultValue="false") boolean play) throws UnsupportedEncodingException {
        try {
            brokerRequest.validate();
            this.getInstitution(brokerRequest.getHomeInstitutionSchacHome());
            this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
        }
        catch (IllegalArgumentException e) {
            return new RedirectView(this.clientUrl + "?error=invalid_request");
        }
        catch (NotFoundException e) {
            return new RedirectView(this.clientUrl + "?error=" + URLEncoder.encode(e.getMessage(), "UTF-8"));
        }
        request.getSession().setAttribute(BROKER_REQUEST_SESSION_KEY, (Object)brokerRequest);
        LOG.debug((Object)String.format("Started session %s for brokerRequest: %s", request.getSession().getId(), brokerRequest));
        String queryParams = play ? "?step=enroll&name=Johanna&correlationID=1" : "?step=approve";
        return new RedirectView(this.clientUrl + queryParams);
    }

    @GetMapping(value={"/api/features"})
    public Map<String, Object> features() {
        LOG.debug((Object)"Received request for feature toggles.");
        return this.featureToggles;
    }

    @GetMapping(value={"/api/offering"})
    public Map<String, Object> offering(HttpServletRequest request) {
        Map offering;
        BrokerRequest brokerRequest = (BrokerRequest)request.getSession().getAttribute(BROKER_REQUEST_SESSION_KEY);
        if (brokerRequest == null) {
            throw new NotFoundException("No broker request in the session");
        }
        LOG.debug((Object)String.format("Received request for offering for brokerRequest %s and session %s", brokerRequest, request.getSession().getId()));
        Institution guestInstitution = this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
        Institution homeInstitution = this.getInstitution(brokerRequest.getHomeInstitutionSchacHome());
        try {
            offering = this.fetchOffering(guestInstitution, brokerRequest);
        }
        catch (RuntimeException e) {
            throw new RemoteException(guestInstitution.getName());
        }
        request.getSession().setAttribute(OFFERING_SESSION_KEY, (Object)offering);
        EnrollmentRequest enrollmentRequest = new EnrollmentRequest(homeInstitution.getPersonsEndpoint(), homeInstitution.getPersonAuthentication(), homeInstitution.getResultsEndpoint(), homeInstitution.getSchacHome(), homeInstitution.getScopes());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("guestInstitution", guestInstitution.sanitize());
        result.put("homeInstitution", homeInstitution.sanitize());
        result.put("authenticationActionUrl", guestInstitution.getAuthenticationEndpoint());
        result.put("enrollmentRequest", enrollmentRequest);
        result.put("offering", offering);
        return result;
    }

    private Institution getInstitution(String institutionSchacHome) {
        LOG.debug((Object)("Lookup institution " + institutionSchacHome + " in serviceregistry."));
        return (Institution)this.serviceRegistry.findInstitutionBySchacHome(institutionSchacHome).orElseThrow(() -> new NotFoundException(String.format("Institution %s unknown", institutionSchacHome)));
    }

    @PostMapping(value={"api/results"})
    public Map<String, Object> results(@RequestBody Map<String, String> correlationMap) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Correlation-ID", correlationMap.get("correlationID"));
        headers.setBasicAuth(this.sisUser, this.sisPassword);
        HttpEntity requestEntity = new HttpEntity(Collections.singletonMap("result", correlationMap.get("result")), (MultiValueMap)headers);
        this.restTemplate.exchange(this.sisResultsEndpoint, HttpMethod.POST, requestEntity, this.mapRef, new Object[0]);
        return Collections.singletonMap("result", "ok");
    }

    @PostMapping(value={"/api/start"})
    public Map<String, Object> start(HttpServletRequest request, @RequestBody Map<String, String> correlationMap) {
        if (((Boolean)this.featureToggles.get("allowPlayground")).booleanValue() && correlationMap.keySet().stream().anyMatch(s -> s.equals("code"))) {
            LOG.debug((Object)("Returning playground request with parameters: " + correlationMap));
            return new HashMap<String, Object>(correlationMap);
        }
        BrokerRequest brokerRequest = (BrokerRequest)request.getSession().getAttribute(BROKER_REQUEST_SESSION_KEY);
        Map offering = (Map)request.getSession().getAttribute(OFFERING_SESSION_KEY);
        LOG.debug((Object)String.format("Received start registration request for brokerRequest: %s and session: %s", brokerRequest, request.getSession().getId()));
        try {
            Map body = this.doStart(brokerRequest, offering, correlationMap);
            request.getSession().invalidate();
            LOG.debug((Object)String.format("Returning start registration response %s for brokerRequest: %s and session: %s", body, brokerRequest, request.getSession().getId()));
            return body;
        }
        catch (HttpStatusCodeException e) {
            LOG.error((Object)"Unexpected exception", (Throwable)e);
            Institution guestInstitution = this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("message", String.format("Server error at %s", guestInstitution.getName()));
            res.put("code", e.getRawStatusCode());
            return res;
        }
    }

    private Map<String, Object> doStart(BrokerRequest brokerRequest, Map<String, Object> offering, Map<String, String> correlationMap) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Correlation-ID", correlationMap.get("correlationID"));
        Institution guestInstitution = this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
        headers.setBasicAuth(guestInstitution.getRegistrationUser(), guestInstitution.getRegistrationPassword());
        HttpEntity requestEntity = new HttpEntity(offering, (MultiValueMap)headers);
        String url = guestInstitution.getRegistrationEndpoint().toString();
        LOG.debug((Object)String.format("Start registration by POST-ing to %s", url));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, this.mapRef, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    private Map<String, Object> fetchOffering(Institution guestInstitution, BrokerRequest brokerRequest) {
        String uri = String.format("%s/%s?expand=academicSession,course", guestInstitution.getCourseEndpoint(), brokerRequest.getOfferingID());
        CourseAuthentication courseAuthentication = guestInstitution.getCourseAuthentication();
        LOG.debug((Object)String.format("Fetching offering from %s with security %s", uri, courseAuthentication.name()));
        if (courseAuthentication.equals((Object)CourseAuthentication.NONE)) {
            LOG.debug((Object)("Fetching " + uri + " without authentication"));
            return (Map)this.restTemplate.getForEntity(uri, Map.class, new Object[0]).getBody();
        }
        if (courseAuthentication.equals((Object)CourseAuthentication.BASIC)) {
            LOG.debug((Object)("Fetching " + uri + " with basic authentication"));
            return (Map)this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicAuthHeaders(guestInstitution)), Map.class, new Object[0]).getBody();
        }
        LOG.debug((Object)("Fetching " + uri + " with OAUTH authentication"));
        return (Map)this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.accessTokenHeaders()), Map.class, new Object[0]).getBody();
    }

    private HttpHeaders basicAuthHeaders(Institution institution) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(institution.getCourseAuthenticationUserName(), institution.getCourseAuthenticationPassword());
        return headers;
    }

    private HttpHeaders accessTokenHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBasicAuth(this.clientId, this.secret);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"scope", (Object)"openid");
        Map result = (Map)this.restTemplate.exchange(this.tokenEndpoint, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), Map.class).getBody();
        String accessToken = (String)result.get("access_token");
        headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Authorization", "Bearer " + accessToken);
        return headers;
    }
}

