/*
 * Decompiled with CFR 0.152.
 */
package broker.api;

import broker.ServiceRegistry;
import broker.domain.Institution;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServiceRegistryController {
    private final ServiceRegistry serviceRegistry;
    private static final Log LOG = LogFactory.getLog(ServiceRegistryController.class);

    public ServiceRegistryController(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @GetMapping(value={"/api/service-registry"})
    public List<Institution> serviceRegistry() {
        LOG.debug((Object)"Received request for service registry.");
        return this.serviceRegistry.allInstitutions().stream().map(Institution::sanitize).collect(Collectors.toList());
    }

    @PostMapping(value={"/api/validate-service-registry-endpoints"})
    public Map<String, Boolean> validate(@RequestBody Map<String, String> enrollmentRequest) {
        LOG.debug((Object)String.format("Validating enrollmentRequest with %s", enrollmentRequest));
        List institutions = this.serviceRegistry.allInstitutions();
        boolean validPersonURI = institutions.stream().anyMatch(institution -> institution.getPersonsEndpoint().equals(enrollmentRequest.get("personURI")));
        boolean validSchacHome = true;
        String homeInstitution = enrollmentRequest.get("homeInstitution");
        if (StringUtils.hasText((String)homeInstitution)) {
            validSchacHome = institutions.stream().anyMatch(institution -> institution.getSchacHome().equals(homeInstitution));
        }
        boolean validResultURI = true;
        String resultsURI = enrollmentRequest.get("resultsURI");
        if (StringUtils.hasText((String)resultsURI)) {
            validResultURI = institutions.stream().anyMatch(institution -> institution.getResultsEndpoint().equals(resultsURI));
        }
        return Collections.singletonMap("valid", validPersonURI && validSchacHome && validResultURI);
    }

    @PostMapping(value={"/api/results-uri"})
    public ResponseEntity<Map<String, String>> resultsURI(@RequestBody Map<String, String> enrollmentRequest) {
        LOG.debug((Object)String.format("Returning resultsURI for %s", enrollmentRequest));
        String homeInstitution = enrollmentRequest.get("homeInstitution");
        return this.serviceRegistry.allInstitutions().stream().filter(ins -> ins.getSchacHome().equals(homeInstitution)).findAny().map(institution -> ResponseEntity.ok(Collections.singletonMap("resultsURI", institution.getResultsEndpoint()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build());
    }
}

