/*
 * Decompiled with CFR 0.152.
 */
package broker.api;

import broker.ServiceRegistry;
import broker.domain.Institution;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServiceRegistryController {
    private final ServiceRegistry serviceRegistry;
    private static final Log LOG = LogFactory.getLog(ServiceRegistryController.class);

    public ServiceRegistryController(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @GetMapping(value={"/api/service-registry"})
    public List<Institution> serviceRegistry() {
        LOG.debug((Object)"Received request for service registry.");
        return this.serviceRegistry.allInstitutions().stream().map(Institution::sanitize).collect(Collectors.toList());
    }

    @PostMapping(value={"/api/validate-service-registry-endpoints"})
    public Map<String, Boolean> validate(@RequestBody Map<String, String> enrollmentRequest) {
        LOG.debug((Object)String.format("Validating enrollmentRequest with %s", enrollmentRequest));
        Collection institutions = this.serviceRegistry.allInstitutions();
        String personURI = enrollmentRequest.get("personURI");
        boolean validPersonURI = institutions.stream().anyMatch(institution -> institution.getPersonsEndpoint().equals(personURI));
        if (!validPersonURI) {
            LOG.info((Object)String.format("Invalid person URI '%s'. No institution with this personsEndpoint", personURI));
        }
        boolean validSchacHome = true;
        String homeInstitution = enrollmentRequest.get("homeInstitution");
        if (StringUtils.hasText((String)homeInstitution) && !(validSchacHome = institutions.stream().anyMatch(institution -> institution.getSchacHome().equals(homeInstitution)))) {
            LOG.info((Object)String.format("Invalid homeInstitution '%s'. No institution with this schacHome", homeInstitution));
        }
        boolean validAssociationURI = true;
        String associationURI = enrollmentRequest.get("associationURI");
        if (StringUtils.hasText((String)associationURI) && !(validAssociationURI = institutions.stream().anyMatch(institution -> institution.getAssociationsEndpoint().equals(associationURI)))) {
            LOG.info((Object)String.format("Invalid associationURI '%s'. No institution with this associationsEndpoint", associationURI));
        }
        return Collections.singletonMap("valid", validPersonURI && validSchacHome && validAssociationURI);
    }

    @PostMapping(value={"/api/associations-uri"})
    public ResponseEntity<Map<String, String>> associationsURI(@RequestBody Map<String, String> enrollmentRequest) {
        LOG.debug((Object)String.format("Returning associationsURI for %s", enrollmentRequest));
        return this.findInstitution(enrollmentRequest).map(institution -> ResponseEntity.ok(Collections.singletonMap("associationsURI", institution.getAssociationsEndpoint()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build());
    }

    @PostMapping(value={"/api/persons-uri"})
    public ResponseEntity<Map<String, String>> personsURI(@RequestBody Map<String, String> enrollmentRequest) {
        LOG.debug((Object)String.format("Returning personsURI for %s", enrollmentRequest));
        return this.findInstitution(enrollmentRequest).map(ins -> ResponseEntity.ok(Collections.singletonMap("personsURI", ins.getPersonsEndpoint()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build());
    }

    private Optional<Institution> findInstitution(Map<String, String> enrollmentRequest) {
        String homeInstitution = enrollmentRequest.get("homeInstitution");
        return this.serviceRegistry.allInstitutions().stream().filter(ins -> ins.getSchacHome().equals(homeInstitution)).findAny();
    }
}

