/*
 * Decompiled with CFR 0.152.
 */
package broker.domain;

import broker.domain.CourseAuthentication;
import broker.domain.PersonAuthentication;
import java.io.Serializable;
import java.net.URI;
import org.springframework.util.Assert;

public class Institution
implements Serializable {
    private String schacHome;
    private String name;
    private String abbreviation;
    private URI authenticationEndpoint;
    private URI courseEndpoint;
    private URI privacyEndpoint;
    private String personsEndpoint;
    private PersonAuthentication personAuthentication;
    private String associationsEndpoint;
    private URI registrationEndpoint;
    private String registrationUser;
    private String registrationPassword;
    private URI logoURI;
    private String scopes;
    private CourseAuthentication courseAuthentication;
    private String courseAuthenticationUserName;
    private String courseAuthenticationPassword;

    public void validate() {
        Assert.notNull((Object)this.courseAuthentication, (String)"courseAuthentication is required");
        if (this.courseAuthentication.equals((Object)CourseAuthentication.BASIC)) {
            Assert.notNull((Object)this.courseAuthenticationUserName, (String)"courseAuthenticationUserName is required for BASIC authentication");
            Assert.notNull((Object)this.courseAuthenticationPassword, (String)"courseAuthenticationPassword is required for BASIC authentication");
        }
        Assert.notNull((Object)this.name, (String)"name is required");
        Assert.notNull((Object)this.abbreviation, (String)"abbreviation is required");
        Assert.notNull((Object)this.courseEndpoint, (String)"courseEndpoint is required");
        Assert.notNull((Object)this.personsEndpoint, (String)"personsEndpoint is required");
        Assert.notNull((Object)this.personAuthentication, (String)"personAuthentication is required");
        Assert.notNull((Object)this.associationsEndpoint, (String)"associationsEndpoint is required");
        Assert.notNull((Object)this.authenticationEndpoint, (String)"authenticationEndpoint is required");
        Assert.notNull((Object)this.registrationEndpoint, (String)"registrationEndpoint is required");
        Assert.notNull((Object)this.registrationUser, (String)"registrationUser is required");
        Assert.notNull((Object)this.registrationPassword, (String)"registrationPassword is required");
        Assert.notNull((Object)this.logoURI, (String)"logoURI is required");
        Assert.notNull((Object)this.scopes, (String)"scopes is required");
        Assert.notNull((Object)this.privacyEndpoint, (String)"privacyEndpoint is required");
    }

    public Institution sanitize() {
        Institution institution = new Institution();
        institution.schacHome = this.schacHome;
        institution.name = this.name;
        institution.logoURI = this.logoURI;
        institution.privacyEndpoint = this.privacyEndpoint;
        institution.abbreviation = this.abbreviation;
        institution.courseEndpoint = this.courseEndpoint;
        institution.courseAuthentication = this.courseAuthentication;
        institution.scopes = this.scopes;
        return institution;
    }

    public String getSchacHome() {
        return this.schacHome;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public URI getAuthenticationEndpoint() {
        return this.authenticationEndpoint;
    }

    public URI getCourseEndpoint() {
        return this.courseEndpoint;
    }

    public URI getPrivacyEndpoint() {
        return this.privacyEndpoint;
    }

    public String getPersonsEndpoint() {
        return this.personsEndpoint;
    }

    public PersonAuthentication getPersonAuthentication() {
        return this.personAuthentication;
    }

    public String getAssociationsEndpoint() {
        return this.associationsEndpoint;
    }

    public URI getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public String getRegistrationUser() {
        return this.registrationUser;
    }

    public String getRegistrationPassword() {
        return this.registrationPassword;
    }

    public URI getLogoURI() {
        return this.logoURI;
    }

    public String getScopes() {
        return this.scopes;
    }

    public CourseAuthentication getCourseAuthentication() {
        return this.courseAuthentication;
    }

    public String getCourseAuthenticationUserName() {
        return this.courseAuthenticationUserName;
    }

    public String getCourseAuthenticationPassword() {
        return this.courseAuthenticationPassword;
    }
}

