/*
 * Decompiled with CFR 0.152.
 */
package broker.queue;

import broker.domain.Institution;
import broker.queue.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QueueService {
    private static final Log LOG = LogFactory.getLog(QueueService.class);
    private static final String withoutHash = "W";
    private final String customerId;
    private final String url;
    private final String redirectUri;

    public QueueService(@Value(value="${config.queueit.url}") String url, @Value(value="${config.queueit.customer_id}") String customerId, @Value(value="${config.queueit.redirect_uri}") String redirectUri) {
        this.url = url;
        this.customerId = customerId;
        this.redirectUri = redirectUri;
    }

    public String getRedirectUrl(Institution institution) {
        String redirect = String.format("%s?c=%s&e=%s&t=%s", this.url, this.customerId, institution.getQueueItWaitingRoom(), this.redirectUri);
        LOG.debug((Object)("Returning redirect url for queueing " + redirect));
        return redirect;
    }

    public boolean validateQueueToken(Institution institution, String queueItToken) {
        String calculatedHash;
        Map queueParams = this.parse(queueItToken);
        if (queueParams.containsKey("ts") && Long.parseLong((String)queueParams.get("ts")) < System.currentTimeMillis() / 1000L) {
            LOG.warn((Object)("Invalid timestamp, got " + (String)queueParams.get("ts")));
            return false;
        }
        if (queueParams.containsKey("e") && !((String)queueParams.get("e")).equalsIgnoreCase(institution.getQueueItWaitingRoom())) {
            LOG.warn((Object)String.format("Queue mismatch, expected %s, but got %s", institution.getQueueItWaitingRoom(), queueParams.get("e")));
            return false;
        }
        if (!queueParams.containsKey("h")) {
            LOG.warn((Object)("Queue token does not contain hash, " + queueParams));
        }
        if (!(calculatedHash = Security.generateSHA256Hash((String)institution.getQueueItSecret(), (String)((String)queueParams.get(withoutHash)))).equalsIgnoreCase((String)queueParams.get("h"))) {
            LOG.warn((Object)String.format("Hash value is different, expected %s, got %s", calculatedHash, queueParams.get("h")));
            return false;
        }
        LOG.debug((Object)("Validated valid queueItToken " + queueItToken));
        return true;
    }

    private Map<String, String> parse(String queueItToken) {
        List<String> parts = Arrays.asList(queueItToken.split("~"));
        Map<String, String> results = parts.stream().map(s -> Arrays.asList(s.split("_"))).filter(l -> l.size() == 2).collect(Collectors.toMap(l -> (String)l.get(0), l -> (String)l.get(1)));
        results.put(withoutHash, queueItToken.replace("~h_" + results.get("h"), ""));
        return results;
    }
}

