/*
 * Decompiled with CFR 0.152.
 */
package broker.registry;

import broker.domain.Institution;
import broker.registry.InstitutionRegistry;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class InMemoryInstitutionRegistry
implements InstitutionRegistry {
    private final Map<String, Institution> institutions;

    public InMemoryInstitutionRegistry(@Value(value="${service_registry.path}") Resource serviceRegistryResource) {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        List institutionList = (List)objectMapper.readValue(serviceRegistryResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        institutionList.forEach(Institution::validate);
        this.institutions = institutionList.stream().collect(Collectors.toMap(Institution::getSchacHome, Function.identity()));
    }

    public Optional<Institution> findInstitutionBySchacHome(String schacHome) {
        return Optional.ofNullable(this.institutions.get(schacHome));
    }

    public Collection<Institution> allInstitutions() {
        return this.institutions.values();
    }
}

