/*
 * Decompiled with CFR 0.152.
 */
package broker.api;

import broker.domain.PollRequest;
import broker.mail.MailBox;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PollController {
    private static final Log LOG = LogFactory.getLog(PollController.class);
    private final MailBox mailBox;

    public PollController(MailBox mailBox) {
        this.mailBox = mailBox;
    }

    @PostMapping(value={"/api/poll"})
    public ResponseEntity<Map<String, Integer>> pollRequest(@RequestBody PollRequest pollRequest) {
        LOG.debug((Object)("Received poll submit: " + pollRequest));
        this.mailBox.sendPollMail(pollRequest);
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        res.put("status", HttpStatus.OK.value());
        return ResponseEntity.ok(res);
    }
}

