/*
 * Decompiled with CFR 0.152.
 */
package home.mail;

import home.mail.MailBox;
import home.mail.MockMailBox;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    @Value(value="${email.from}")
    private String emailFrom;
    @Autowired
    private JavaMailSender mailSender;

    @Bean
    @Profile(value={"!test", "!dev"})
    public MailBox mailSenderProd() throws IOException {
        return new MailBox(this.mailSender, this.emailFrom);
    }

    @Bean
    @Profile(value={"test", "dev"})
    @Primary
    public MailBox mailSenderDev(Environment environment) throws IOException {
        return new MockMailBox(this.mailSender, this.emailFrom, environment);
    }
}

