/*
 * Decompiled with CFR 0.152.
 */
package mail.api;

import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import mail.MailBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IntakeEndpoint {
    private static final Log LOG = LogFactory.getLog(IntakeEndpoint.class);
    private final MailBox mailBox;

    public IntakeEndpoint(MailBox mailBox) {
        this.mailBox = mailBox;
    }

    @PostMapping(value={"/intake"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Map<String, Object>> intake(HttpServletRequest request, @RequestBody Map<String, Map<String, Object>> body) throws MessagingException {
        String language = request.getHeader("Accept-Language");
        Map<String, Object> person = body.get("person");
        Map<String, Object> offering = body.get("offering");
        String offeringId = (String)offering.get("offeringId");
        String mail = (String)person.get("mail");
        LOG.debug((Object)("Starting email intake for " + mail));
        this.mailBox.sendUserConfirmation((String)person.get("displayName"), mail, offeringId, (String)offering.get("name"), (String)person.get("secondaryMail"), (String)person.get("initials"), (String)person.get("personId"));
        String message = StringUtils.hasText((String)language) && language.startsWith("nl") ? "Controlleer je mailbox voor meer informatie" : "Check your mailbox for more information";
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", "ok");
        result.put("code", 200);
        result.put("message", message);
        result.put("oo-api-offering-id", offeringId);
        LOG.debug((Object)("Finished email intake for " + mail + ". Sending code 200 back."));
        return ResponseEntity.ok(result);
    }
}

