/*
 * Decompiled with CFR 0.152.
 */
package generiek;

import generiek.model.EnrollmentRequest;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ServiceRegistry {
    private final String serviceRegistryBaseURL;
    private final RestTemplate restTemplate = new RestTemplate();

    public ServiceRegistry(@Value(value="${broker.service_registry_base_url}") String serviceRegistryBaseURL) {
        this.serviceRegistryBaseURL = serviceRegistryBaseURL;
    }

    public Map<String, Boolean> validate(EnrollmentRequest enrollmentRequest) {
        return (Map)this.restTemplate.postForEntity(this.serviceRegistryBaseURL + "/api/validate-service-registry-endpoints", (Object)new HttpEntity((Object)enrollmentRequest), Map.class, new Object[0]).getBody();
    }

    public String resultsURI(EnrollmentRequest enrollmentRequest) {
        Map results = (Map)this.restTemplate.postForEntity(this.serviceRegistryBaseURL + "/api/results-uri", (Object)new HttpEntity(Collections.singletonMap("homeInstitution", enrollmentRequest.getHomeInstitution())), Map.class, new Object[0]).getBody();
        return (String)results.get("resultsURI");
    }

    public String getServiceRegistryBaseURL() {
        return this.serviceRegistryBaseURL;
    }
}

