/*
 * Decompiled with CFR 0.152.
 */
package generiek.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import generiek.LanguageFilter;
import generiek.ServiceRegistry;
import generiek.jwt.JWTValidator;
import generiek.model.EnrollmentRequest;
import generiek.model.PersonAuthentication;
import generiek.ooapi.EnrollmentResult;
import generiek.repository.EnrollmentRepository;
import generiek.repository.ExpiredEnrollmentRequestException;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class EnrollmentEndpoint {
    private static final Log LOG = LogFactory.getLog(EnrollmentEndpoint.class);
    private final String acr;
    private final String clientId;
    private final String clientSecret;
    private final String redirectUri;
    private final URI authorizationUri;
    private final URI tokenUri;
    private final String jwkSetUri;
    private final URI backendUrl;
    private final String backendApiUser;
    private final String backendApiPassword;
    private final String brokerUrl;
    private final ServiceRegistry serviceRegistry;
    private final boolean allowPlayground;
    private final EnrollmentRepository enrollmentRepository;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate = new RestTemplate();
    private final ParameterizedTypeReference<Map<String, Object>> mapRef = new /* Unavailable Anonymous Inner Class!! */;
    private final JWTValidator jwtValidator = new JWTValidator();

    public EnrollmentEndpoint(@Value(value="${oidc.acr-context-class-ref}") String acr, @Value(value="${oidc.client-id}") String clientId, @Value(value="${oidc.client-secret}") String clientSecret, @Value(value="${oidc.redirect-uri}") String redirectUri, @Value(value="${oidc.authorization-uri}") URI authorizationUri, @Value(value="${oidc.token-uri}") URI tokenUri, @Value(value="${oidc.jwk-set-uri}") String jwkSetUri, @Value(value="${backend.url}") URI backendUrl, @Value(value="${backend.api_user}") String backendApiUser, @Value(value="${backend.api_password}") String backendApiPassword, @Value(value="${broker.url}") String brokerUrl, @Value(value="${features.allow_playground}") boolean allowPlayground, EnrollmentRepository enrollmentRepository, ServiceRegistry serviceRegistry, ObjectMapper objectMapper) {
        this.acr = acr;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.authorizationUri = authorizationUri;
        this.tokenUri = tokenUri;
        this.jwkSetUri = jwkSetUri;
        this.backendUrl = backendUrl;
        this.backendApiUser = backendApiUser;
        this.backendApiPassword = backendApiPassword;
        this.brokerUrl = brokerUrl;
        this.enrollmentRepository = enrollmentRepository;
        this.serviceRegistry = serviceRegistry;
        this.objectMapper = objectMapper;
        this.allowPlayground = allowPlayground;
        this.restTemplate.setInterceptors(Collections.singletonList((request, body, execution) -> {
            request.getHeaders().add("Accept-Language", (String)LanguageFilter.language.get());
            return execution.execute(request, body);
        }));
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        String[] denylist = new String[]{"class.*", "Class.*", "*.class.*", "*.Class.*"};
        dataBinder.setDisallowedFields(denylist);
    }

    @PostMapping(value={"/api/enrollment"}, consumes={"application/x-www-form-urlencoded"})
    public View enrollment(@ModelAttribute EnrollmentRequest enrollmentRequest) throws IOException {
        LOG.debug((Object)("Received authorization for enrollment request: " + enrollmentRequest));
        try {
            enrollmentRequest = new EnrollmentRequest(enrollmentRequest);
            this.validateServiceRegistryEndpoints(enrollmentRequest);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Invalid enrollmentRequest: " + enrollmentRequest), (Throwable)e);
            String redirect = String.format("%s?error=%s", this.brokerUrl, "Invalid enrollmentRequest");
            return new RedirectView(redirect, false);
        }
        String authorizationURI = this.buildAuthorizationURI(enrollmentRequest);
        LOG.debug((Object)("Starting authorization for enrollment request: " + enrollmentRequest));
        return new RedirectView(authorizationURI);
    }

    @GetMapping(value={"/redirect_uri"})
    public View redirect(@RequestParam(value="code") String code, @RequestParam(value="state") String state) throws ParseException, IOException {
        EnrollmentRequest enrollmentRequest;
        Map body;
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"redirect_uri", (Object)this.redirectUri);
        try {
            body = this.tokenRequest((MultiValueMap)map);
        }
        catch (RestClientException e) {
            LOG.error((Object)"Exception in token request", (Throwable)e);
            String redirect = String.format("%s?error=%s", this.brokerUrl, "Session lost. Please try again");
            return new RedirectView(redirect, false);
        }
        String accessToken = (String)body.get("access_token");
        String refreshToken = (String)body.get("refresh_token");
        String idToken = (String)body.get("id_token");
        JWKSource securityContextJWKSource = this.jwtValidator.parseKeySet(this.jwkSetUri);
        this.jwtValidator.validate(accessToken, securityContextJWKSource);
        JWTClaimsSet claimsSet = this.jwtValidator.validate(idToken, securityContextJWKSource);
        String givenName = claimsSet.getStringClaim("given_name");
        givenName = StringUtils.hasText((String)givenName) ? givenName : "Mystery guest";
        givenName = URLEncoder.encode(givenName, "UTF-8");
        String eduid = claimsSet.getStringClaim("eduid");
        if (!StringUtils.hasText((String)eduid)) {
            String redirect = String.format("%s?error=%s", this.brokerUrl, "eduid is required. Check the ARP for RP:" + this.clientId);
            return new RedirectView(redirect, false);
        }
        try {
            enrollmentRequest = EnrollmentRequest.serializeFromBase64((ObjectMapper)this.objectMapper, (String)state);
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.error((Object)"Redirect after authorization called and no valid enrollment request", (Throwable)e);
            String redirect = String.format("%s?error=%s", this.brokerUrl, "Session lost. Please try again");
            return new RedirectView(redirect, false);
        }
        LOG.debug((Object)("Redirect after authorization called for enrollment request: " + enrollmentRequest));
        enrollmentRequest.setEduid(eduid);
        enrollmentRequest.setAccessToken(accessToken);
        enrollmentRequest.setRefreshToken(refreshToken);
        this.enrollmentRepository.save((Object)enrollmentRequest);
        String redirect = String.format("%s?step=enroll&correlationID=%s&name=%s", this.brokerUrl, enrollmentRequest.getIdentifier(), givenName);
        LOG.debug((Object)String.format("Redirecting back to %s client after authorization", redirect));
        return new RedirectView(redirect, false);
    }

    private Map<String, Object> tokenRequest(MultiValueMap<String, String> map) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity request = new HttpEntity(map, (MultiValueMap)headers);
        return (Map)this.restTemplate.exchange(this.tokenUri, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody();
    }

    @PostMapping(value={"/api/start"})
    public ResponseEntity<Map<String, Object>> start(@RequestHeader(value="X-Correlation-ID") String correlationId, @RequestBody Map<String, Object> offering) {
        Map personMap;
        LOG.debug((Object)String.format("Received start registration from broker for correlation-id %s and offering %s", correlationId, offering));
        EnrollmentRequest enrollmentRequest = (EnrollmentRequest)this.enrollmentRepository.findByIdentifier(correlationId).orElseThrow(ExpiredEnrollmentRequestException::new);
        LOG.debug((Object)String.format("Found matching enrollment request %s for correlation-id %s", enrollmentRequest, correlationId));
        HashMap<String, Map> body = new HashMap<String, Map>();
        body.put("offering", offering);
        try {
            personMap = this.person(enrollmentRequest);
        }
        catch (HttpStatusCodeException e) {
            LOG.error((Object)("Error in retrieving person for enrollmentRequest: " + enrollmentRequest), (Throwable)e);
            return this.errorResponseEntity("Error in retrieving person for enrollmentRequest: " + enrollmentRequest, e);
        }
        LOG.debug((Object)String.format("Replacing personId %s with eduID %s", personMap.get("personId"), enrollmentRequest.getEduid()));
        personMap.put("personId", enrollmentRequest.getEduid());
        body.put("person", personMap);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setBasicAuth(this.backendApiUser, this.backendApiPassword);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)httpHeaders);
        LOG.debug((Object)"Returning registration result to broker");
        try {
            return this.restTemplate.exchange(this.backendUrl, HttpMethod.POST, httpEntity, this.mapRef);
        }
        catch (HttpStatusCodeException e) {
            LOG.error((Object)("Error in registration results for enrollmentRequest: " + enrollmentRequest), (Throwable)e);
            return this.errorResponseEntity("Error in registration results for enrollmentRequest: " + enrollmentRequest, e);
        }
    }

    @PostMapping(value={"/api/play-results"})
    public ResponseEntity<Void> playResults(@RequestHeader(value="X-Correlation-ID") String correlationId, @RequestBody Map<String, Object> results) {
        if (!this.allowPlayground) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        EnrollmentRequest enrollmentRequest = (EnrollmentRequest)this.enrollmentRepository.findByIdentifier(correlationId).orElseThrow(ExpiredEnrollmentRequestException::new);
        HashMap<String, Object> newResults = new HashMap<String, Object>(results);
        newResults.put("personId", enrollmentRequest.getEduid());
        return this.results(newResults);
    }

    @PostMapping(value={"/api/results"})
    public ResponseEntity results(@RequestBody Map<String, Object> results) {
        String resultsURI;
        Map oidcResponse;
        String personId = (String)results.get("personId");
        List enrollmentRequests = this.enrollmentRepository.findByEduidOrderByCreatedDesc(personId);
        if (CollectionUtils.isEmpty((Collection)enrollmentRequests)) {
            LOG.debug((Object)String.format("Enrollment not found for :", personId));
            throw new ExpiredEnrollmentRequestException();
        }
        EnrollmentRequest enrollmentRequest = (EnrollmentRequest)enrollmentRequests.get(0);
        LOG.debug((Object)String.format("Report back results endpoint called by SIS personId %s and enrolment request %s", personId, enrollmentRequest));
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"refresh_token", (Object)enrollmentRequest.getRefreshToken());
        LOG.debug((Object)("Obtaining new accessToken with saved refreshToken for enrolment request: " + enrollmentRequest));
        try {
            oidcResponse = this.tokenRequest((MultiValueMap)map);
        }
        catch (HttpStatusCodeException e) {
            LOG.error((Object)("Error in obtaining new accessToken with saved refreshToken for enrolment request:" + enrollmentRequest), (Throwable)e);
            return this.errorResponseEntity("Error in obtaining new accessToken with saved refreshToken for enrolment request:" + enrollmentRequest, e);
        }
        String accessToken = (String)oidcResponse.get("access_token");
        String refreshToken = (String)oidcResponse.get("refresh_token");
        enrollmentRequest.setAccessToken(accessToken);
        enrollmentRequest.setRefreshToken(refreshToken);
        this.enrollmentRepository.save((Object)enrollmentRequest);
        try {
            resultsURI = this.serviceRegistry.resultsURI(enrollmentRequest);
        }
        catch (HttpStatusCodeException e) {
            LOG.error((Object)("Error in obtaining resultsURI for enrolment request:" + enrollmentRequest), (Throwable)e);
            return this.errorResponseEntity("Error in obtaining resultsURI for enrolment request:" + enrollmentRequest, e);
        }
        LOG.debug((Object)String.format("Posting back results endpoint for personId %s and enrolment request %s to %s", personId, enrollmentRequest, resultsURI));
        HttpHeaders httpHeaders = this.getOidcAuthorizationHttpHeaders(accessToken, PersonAuthentication.HEADER.name());
        Map body = new EnrollmentResult(results).transform();
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity exchanged = this.restTemplate.exchange(resultsURI, HttpMethod.POST, requestEntity, Void.class, new Object[0]);
            LOG.debug((Object)String.format("Received answer from %s with status %s", resultsURI, exchanged.getStatusCode()));
            return ResponseEntity.ok().body(exchanged.getBody());
        }
        catch (HttpStatusCodeException e) {
            LOG.error((Object)String.format("Error %s from the OOAPI results endpoint for enrolment request: %s. Message: %s", e.getStatusCode(), enrollmentRequest, e.getMessage()));
            return ResponseEntity.status((HttpStatus)e.getStatusCode()).body((Object)e.getResponseBodyAsString());
        }
    }

    private ResponseEntity<Map<String, Object>> errorResponseEntity(String description, HttpStatusCodeException e) {
        LOG.error((Object)description, (Throwable)e);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("error", true);
        results.put("message", e.getMessage());
        results.put("description", description);
        return ResponseEntity.status((HttpStatus)e.getStatusCode()).body(results);
    }

    private Map<String, Object> person(EnrollmentRequest enrollmentRequest) {
        String personAuth = enrollmentRequest.getPersonAuth();
        HttpHeaders httpHeaders = this.getOidcAuthorizationHttpHeaders(enrollmentRequest.getAccessToken(), personAuth);
        LOG.debug((Object)("Retrieve person information from : " + enrollmentRequest.getPersonURI() + " using personAuth; " + personAuth));
        if (personAuth.equalsIgnoreCase(PersonAuthentication.FORM.name())) {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"access_token", (Object)enrollmentRequest.getAccessToken());
            HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)httpHeaders);
            return (Map)this.restTemplate.exchange(enrollmentRequest.getPersonURI(), HttpMethod.POST, requestEntity, this.mapRef, new Object[0]).getBody();
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)httpHeaders);
        return (Map)this.restTemplate.exchange(enrollmentRequest.getPersonURI(), HttpMethod.GET, requestEntity, this.mapRef, new Object[0]).getBody();
    }

    private HttpHeaders getOidcAuthorizationHttpHeaders(String accessToken, String personAuth) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Accept", "application/json, application/json;charset=UTF-8");
        if (personAuth.equalsIgnoreCase(PersonAuthentication.FORM.name())) {
            httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        } else {
            httpHeaders.setBearerAuth(accessToken);
        }
        return httpHeaders;
    }

    private String buildAuthorizationURI(EnrollmentRequest enrollmentRequest) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        String base64Enrollment = enrollmentRequest.serializeToBase64(this.objectMapper);
        List entries = Stream.of("family_name", "given_name", "eduid").map(ClaimsSetRequest.Entry::new).collect(Collectors.toList());
        params.put("claims", new OIDCClaimsRequest().withIDTokenClaimsRequest(new ClaimsSetRequest(entries)).toJSONString());
        params.put("acr_values", this.acr);
        params.put("scope", "openid " + enrollmentRequest.getScope());
        params.put("client_id", this.clientId);
        params.put("response_type", "code");
        params.put("redirect_uri", this.redirectUri);
        params.put("state", base64Enrollment);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.authorizationUri);
        params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        return builder.build().encode().toUriString();
    }

    private void validateServiceRegistryEndpoints(EnrollmentRequest enrollmentRequest) {
        LOG.debug((Object)String.format("Calling validate enrollmentRequest with %s", enrollmentRequest));
        Map results = this.serviceRegistry.validate(enrollmentRequest);
        if (!((Boolean)results.get("valid")).booleanValue()) {
            throw new IllegalArgumentException(String.format("Invalid URI's for enrolment %s provided reported by %s", enrollmentRequest, this.serviceRegistry.getServiceRegistryBaseURL()));
        }
    }
}

