/*
 * Decompiled with CFR 0.152.
 */
package generiek.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.net.URL;

public class JWTValidator {
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor = new DefaultJWTProcessor();

    public JWTClaimsSet validate(String jwtToken, JWKSource<SecurityContext> keySource) {
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(JWSAlgorithm.RS256, keySource);
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        return this.jwtProcessor.process(jwtToken, null);
    }

    public JWKSource<SecurityContext> parseKeySet(String jwkSetUri) {
        return new RemoteJWKSet(new URL(jwkSetUri));
    }
}

