/*
 * Decompiled with CFR 0.152.
 */
package generiek;

import generiek.model.EnrollmentRequest;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ServiceRegistry {
    private final String serviceRegistryBaseURL;
    private final RestTemplate restTemplate;

    public ServiceRegistry(@Value(value="${broker.service_registry_base_url}") String serviceRegistryBaseURL, @Value(value="${config.connection_timeout_millis}") int connectionTimeoutMillis) {
        this.serviceRegistryBaseURL = serviceRegistryBaseURL;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        builder.readTimeout((long)connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        builder.retryOnConnectionFailure(true);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(builder.build()));
    }

    public Map<String, Boolean> validate(EnrollmentRequest enrollmentRequest) {
        return (Map)this.restTemplate.postForEntity(this.serviceRegistryBaseURL + "/api/validate-service-registry-endpoints", (Object)new HttpEntity((Object)enrollmentRequest), Map.class, new Object[0]).getBody();
    }

    public String associationsURI(EnrollmentRequest enrollmentRequest) {
        Map results = (Map)this.restTemplate.postForEntity(this.serviceRegistryBaseURL + "/api/associations-uri", (Object)new HttpEntity(Collections.singletonMap("homeInstitution", enrollmentRequest.getHomeInstitution())), Map.class, new Object[0]).getBody();
        return (String)results.get("associationsURI");
    }

    public String personsURI(EnrollmentRequest enrollmentRequest) {
        Map results = (Map)this.restTemplate.postForEntity(this.serviceRegistryBaseURL + "/api/persons-uri", (Object)new HttpEntity(Collections.singletonMap("homeInstitution", enrollmentRequest.getHomeInstitution())), Map.class, new Object[0]).getBody();
        return (String)results.get("personsURI");
    }

    public String getServiceRegistryBaseURL() {
        return this.serviceRegistryBaseURL;
    }
}

