/*
 * Decompiled with CFR 0.152.
 */
package generiek.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.net.MalformedURLException;
import java.net.URL;

public class JWTValidator {
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor = new DefaultJWTProcessor();

    public JWTValidator(String jwkSetUri) throws MalformedURLException {
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(JWSAlgorithm.RS256, (JWKSource)new RemoteJWKSet(new URL(jwkSetUri)));
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
    }

    public JWTClaimsSet validate(String jwtToken) {
        return this.jwtProcessor.process(jwtToken, null);
    }
}

